/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.column;

import de.unknownreality.dataframe.column.BasicColumn;
import de.unknownreality.dataframe.common.NumberUtil;
import de.unknownreality.dataframe.common.math.Quantiles;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NumberColumn<T extends Number, C extends NumberColumn<T, C>>
extends BasicColumn<T, C> {
    private static final Logger log = LoggerFactory.getLogger(NumberColumn.class);

    public NumberColumn(String name) {
        super(name);
    }

    public NumberColumn() {
        super(null);
    }

    public NumberColumn(String name, T[] values) {
        super(name, (Comparable[])values);
    }

    public NumberColumn(String name, T[] values, int size) {
        super(name, (Comparable[])values, size);
    }

    @Override
    public T get(int index) {
        return (T)((Number[])this.values)[index];
    }

    public T median() {
        return new Quantiles(this.getSortedValues(), this.getType(), true).median();
    }

    public T getQuantile(double percent) {
        return new Quantiles(this.getSortedValues(), this.getType(), true).getQuantile(percent);
    }

    public Quantiles<T> getQuantiles() {
        return new Quantiles(this.getSortedValues(), this.getType(), true);
    }

    public Double mean() {
        int naCount = 0;
        Double sum = 0.0;
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.isNA(i)) {
                ++naCount;
                continue;
            }
            ++count;
            sum = sum + ((Number)this.get(i)).doubleValue();
        }
        if (naCount > 0) {
            log.warn("mean() ignored {} NA", (Object)naCount);
        }
        return sum / (double)count;
    }

    public T min() {
        Double min = Double.MAX_VALUE;
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.isNA(i)) {
                ++naCount;
                continue;
            }
            min = Math.min(min, ((Number)this.get(i)).doubleValue());
        }
        if (naCount > 0) {
            log.warn("min() ignored {} NA", (Object)naCount);
        }
        return NumberUtil.convert(min, this.getType());
    }

    public T max() {
        double max = Double.NEGATIVE_INFINITY;
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.isNA(i)) {
                ++naCount;
                continue;
            }
            max = Math.max(max, ((Number)this.get(i)).doubleValue());
        }
        if (naCount > 0) {
            log.warn("max() ignored {} NA", (Object)naCount);
        }
        return NumberUtil.convert(max, this.getType());
    }

    public T sum() {
        int naCount = 0;
        double sum = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.isNA(i)) {
                ++naCount;
                continue;
            }
            sum += ((Number)this.get(i)).doubleValue();
        }
        if (naCount > 0) {
            log.warn("sum() ignored {} NA", (Object)naCount);
        }
        return NumberUtil.convert(sum, this.getType());
    }

    public C add(NumberColumn column) {
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && !column.isNA(i)) {
                this.doSet(i, (Comparable)NumberUtil.add(this.get(i), column.get(i), this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("add() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    protected T[] getSortedValues() {
        Number[] sortedValues = (Number[])this.toArray();
        Arrays.sort(sortedValues, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return ((Comparable)o1).compareTo(o2);
            }
        });
        return sortedValues;
    }

    public C subtract(NumberColumn column) {
        if (column.size() != this.size()) {
            throw new IllegalArgumentException("'subtract' requires column of same size");
        }
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && !column.isNA(i)) {
                this.doSet(i, (Comparable)NumberUtil.subtract(this.get(i), column.get(i), this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("subtract() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    public C multiply(NumberColumn column) {
        if (column.size() != this.size()) {
            throw new IllegalArgumentException("'multiply' requires column of same size");
        }
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && !column.isNA(i)) {
                this.doSet(i, (Comparable)NumberUtil.multiply(this.get(i), column.get(i), this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("multiply() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    public C divide(NumberColumn column) {
        if (column.size() != this.size()) {
            throw new IllegalArgumentException("'divide' requires column of same size");
        }
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && !column.isNA(i)) {
                this.doSet(i, (Comparable)NumberUtil.divide(this.get(i), column.get(i), this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("divide() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    public C add(Number value) {
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && value != null) {
                this.doSet(i, (Comparable)NumberUtil.add(this.get(i), value, this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("add() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    public C subtract(Number value) {
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && value != null) {
                this.doSet(i, (Comparable)NumberUtil.subtract(this.get(i), value, this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("subtract() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    public C multiply(Number value) {
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && value != null) {
                this.doSet(i, (Comparable)NumberUtil.multiply(this.get(i), value, this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("multiply() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    public C divide(Number value) {
        int naCount = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isNA(i) && value != null) {
                this.doSet(i, (Comparable)NumberUtil.divide(this.get(i), value, this.getType()));
                continue;
            }
            ++naCount;
        }
        if (naCount > 0) {
            log.warn("divide() ignored {} NA", (Object)naCount);
        }
        this.notifyDataFrameColumnChanged();
        return (C)((NumberColumn)this.getThis());
    }

    @Override
    protected boolean doAppend(T t) {
        if (t != null && t.getClass() != this.getType()) {
            t = NumberUtil.convert(t, this.getType());
        }
        return super.doAppend((Comparable)t);
    }

    @Override
    public boolean isValueValid(Comparable value) {
        return super.isValueValid(value) || value != null && Number.class.isAssignableFrom(value.getClass());
    }

    @Override
    protected void setValue(int index, T value) {
        ((Number[])this.values)[index] = NumberUtil.convert(value, this.getType());
    }
}

