/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class NumberUtil {
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);

    private NumberUtil() {
    }

    public static <T extends Number> T add(Number a, Number b, Class<T> cl) {
        return NumberUtil.convert(a.doubleValue() + b.doubleValue(), cl);
    }

    public static <T extends Number> T subtract(Number a, Number b, Class<T> cl) {
        return NumberUtil.convert(a.doubleValue() - b.doubleValue(), cl);
    }

    public static <T extends Number> T multiply(Number a, Number b, Class<T> cl) {
        return NumberUtil.convert(a.doubleValue() * b.doubleValue(), cl);
    }

    public static <T extends Number> T divide(Number a, Number b, Class<T> cl) {
        return NumberUtil.convert(a.doubleValue() / b.doubleValue(), cl);
    }

    public static boolean le(Number a, Number b) {
        return NumberUtil.compare(a, b) <= 0;
    }

    public static boolean lt(Number a, Number b) {
        return NumberUtil.compare(a, b) < 0;
    }

    public static boolean ge(Number a, Number b) {
        return NumberUtil.compare(a, b) >= 0;
    }

    public static boolean gt(Number a, Number b) {
        return NumberUtil.compare(a, b) > 0;
    }

    public static boolean eq(Number a, Number b) {
        return NumberUtil.compare(a, b) == 0;
    }

    public static Number max(Number a, Number b) {
        int c = NumberUtil.compare(a, b);
        if (c > 0) {
            return a;
        }
        return b;
    }

    public static Number min(Number a, Number b) {
        int c = NumberUtil.compare(a, b);
        if (c < 0) {
            return a;
        }
        return b;
    }

    public static int compare(Number a, Number b) {
        if (NumberUtil.isSpecialNumber(a) || NumberUtil.isSpecialNumber(b)) {
            return Double.compare(a.doubleValue(), b.doubleValue());
        }
        return NumberUtil.toBigDecimal(a).compareTo(NumberUtil.toBigDecimal(b));
    }

    public static boolean isSpecialNumber(Number number) {
        if (number instanceof Double && !Double.isFinite((Double)number)) {
            return true;
        }
        return number instanceof Float && !Float.isFinite(((Float)number).floatValue());
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Float || number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        try {
            return new BigDecimal(number.toString());
        }
        catch (NumberFormatException e) {
            throw new DataFrameRuntimeException("\"" + number + "\" of class " + number.getClass().getName() + " can not be converted to String", e);
        }
    }

    public static Number parseNumber(String numberStr) throws ParseException {
        return NUMBER_FORMAT.parse(numberStr);
    }

    public static Number parseNumberOrNull(String numberStr) {
        try {
            return NumberUtil.parseNumber(numberStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean isFloatOrDouble(Number number) {
        return number instanceof Float || number instanceof Double;
    }

    public static String toString(Number number) {
        return NUMBER_FORMAT.format(number);
    }

    public static <T extends Number> T convert(Number n, Class<T> cl) {
        if (n.getClass() == cl) {
            return (T)n;
        }
        if (cl == Double.class) {
            return (T)Double.valueOf(n.doubleValue());
        }
        if (cl == Integer.class) {
            return (T)Integer.valueOf(n.intValue());
        }
        if (cl == Float.class) {
            return (T)Float.valueOf(n.floatValue());
        }
        if (cl == Long.class) {
            return (T)Long.valueOf(n.longValue());
        }
        if (cl == Short.class) {
            return (T)Short.valueOf(n.shortValue());
        }
        if (cl == Byte.class) {
            return (T)Byte.valueOf(n.byteValue());
        }
        return null;
    }
}

