/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.header;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Header;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class BasicTypeHeader<T>
implements Header<T> {
    private final Map<T, Integer> headerMap = new HashMap<T, Integer>();
    private final List<T> headers = new ArrayList<T>();
    private final Map<T, Class<? extends Comparable>> typesMap = new HashMap<T, Class<? extends Comparable>>();
    private final Map<T, Class<? extends DataFrameColumn>> colTypeMap = new HashMap<T, Class<? extends DataFrameColumn>>();

    @Override
    public int size() {
        return this.headers.size();
    }

    public BasicTypeHeader add(T headerName, DataFrameColumn<?, ?> column) {
        return this.add(headerName, column.getClass(), column.getType());
    }

    public BasicTypeHeader add(T name, Class<? extends DataFrameColumn> colClass, Class<? extends Comparable> type) {
        int index = this.headers.size();
        this.headers.add(name);
        this.headerMap.put(name, index);
        this.typesMap.put(name, type);
        this.colTypeMap.put(name, colClass);
        return this;
    }

    public BasicTypeHeader set(T name, Class<? extends DataFrameColumn> colClass, Class<? extends Comparable> type) {
        Integer index = this.headerMap.get(name);
        if (index == null) {
            this.add(name, colClass, type);
        }
        this.typesMap.put(name, type);
        this.colTypeMap.put(name, colClass);
        return this;
    }

    public BasicTypeHeader replace(T existing, T replacement, Class<? extends DataFrameColumn> colClass, Class<? extends Comparable> type) {
        Integer index = this.headerMap.get(existing);
        if (index == null) {
            throw new DataFrameRuntimeException(String.format("header not found: %s", existing));
        }
        this.headers.remove(existing);
        this.headers.add(index, replacement);
        this.headerMap.put(replacement, index);
        this.typesMap.remove(existing);
        this.colTypeMap.remove(existing);
        this.typesMap.put(replacement, type);
        this.colTypeMap.put(replacement, colClass);
        return this;
    }

    public void remove(T name) {
        boolean fix = false;
        for (T s : this.headers) {
            if (!fix && s.equals(name)) {
                fix = true;
                continue;
            }
            if (!fix) continue;
            this.headerMap.put(s, this.headerMap.get(s) - 1);
        }
        this.headers.remove(name);
        this.headerMap.remove(name);
        this.typesMap.remove(name);
        this.colTypeMap.remove(name);
    }

    public void rename(T oldName, T newName) {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!this.headers.get(i).equals(oldName)) continue;
            this.headers.set(i, newName);
            Class<? extends Comparable> type = this.typesMap.get(oldName);
            this.typesMap.remove(oldName);
            this.typesMap.put(newName, type);
            Class<? extends DataFrameColumn> colType = this.colTypeMap.get(oldName);
            this.colTypeMap.remove(oldName);
            this.colTypeMap.put(newName, colType);
            Integer index = this.headerMap.get(oldName);
            this.headerMap.remove(oldName);
            this.headerMap.put(newName, index);
            return;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        BasicTypeHeader otherHeader = (BasicTypeHeader)other;
        if (this.size() != otherHeader.size()) {
            return false;
        }
        for (T s : this.headers) {
            if (!otherHeader.contains(s)) {
                return false;
            }
            if (this.getType(s) == otherHeader.getType(s)) continue;
            return false;
        }
        return true;
    }

    public Class<? extends DataFrameColumn> getColumnType(T name) {
        return this.colTypeMap.get(name);
    }

    public Class<? extends DataFrameColumn> getColumnType(int index) {
        return this.colTypeMap.get(this.get(index));
    }

    public Class<? extends Comparable> getType(T name) {
        return this.typesMap.get(name);
    }

    public Class<? extends Comparable> getType(int index) {
        return this.typesMap.get(this.get(index));
    }

    @Override
    public T get(int index) {
        if (index >= this.headers.size()) {
            throw new DataFrameRuntimeException(String.format("header index out of bounds %d > %d", index, this.headers.size() - 1));
        }
        return this.headers.get(index);
    }

    @Override
    public boolean contains(T name) {
        return this.headerMap.containsKey(name);
    }

    public void clear() {
        this.headerMap.clear();
        this.headers.clear();
        this.typesMap.clear();
    }

    @Override
    public int getIndex(T name) {
        Integer index = this.headerMap.get(name);
        if (index == null) {
            throw new DataFrameRuntimeException(String.format("column header name not found '%s'", name));
        }
        return index;
    }

    public abstract BasicTypeHeader copy();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        for (int i = 0; i < this.headers.size(); ++i) {
            sb.append(this.headers.get(i));
            if (i >= this.headers.size() - 1) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported");
            }

            @Override
            public boolean hasNext() {
                return this.i != BasicTypeHeader.this.headers.size();
            }

            @Override
            public T next() {
                if (this.i >= BasicTypeHeader.this.headers.size()) {
                    throw new NoSuchElementException(String.format("element not found: index out of bounds %s >= %s]", this.i, BasicTypeHeader.this.headers.size()));
                }
                return BasicTypeHeader.this.headers.get(this.i++);
            }
        };
    }
}

