/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.math;

import de.unknownreality.dataframe.common.NumberUtil;
import java.util.Arrays;

public class Quantiles<T extends Number> {
    private T[] values;
    private Class<T> cl;

    public Quantiles(T[] values, Class<T> cl, boolean sorted) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("empty value arrays are not allowed for quantile calculations");
        }
        this.values = values;
        this.cl = cl;
        if (!sorted) {
            Arrays.sort(values);
        }
    }

    public T getQuantile(double quantile) {
        int index = (int)Math.ceil(quantile * (double)this.values.length) - 1;
        index = index < 0 ? 0 : index;
        return this.values[index];
    }

    public T median() {
        return NumberUtil.convert(this.values[this.values.length / 2], this.cl);
    }

    public T max() {
        return this.values[this.values.length - 1];
    }

    public T min() {
        return this.values[0];
    }
}

