/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.row;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Header;
import de.unknownreality.dataframe.common.row.AbstractHeaderRow;

public abstract class UpdatableRow<T, H extends Header<T>, V>
extends AbstractHeaderRow<T, H, V> {
    public UpdatableRow(H header, int index) {
        super(header, index);
    }

    public void set(T headerName, V value) {
        if (!this.getHeader().contains(headerName)) {
            throw new DataFrameRuntimeException(String.format("header name not found '%s'", headerName));
        }
        if (!this.isCompatible(value, headerName)) {
            throw new DataFrameRuntimeException(String.format("the value (%s) is not compatible with this column (%s)", value.getClass(), headerName));
        }
        this.setValue(this.getHeader().getIndex(headerName), value);
    }

    public abstract boolean isCompatible(V var1, T var2);

    public abstract boolean isCompatible(V var1, int var2);

    public void set(int index, V value) {
        if (this.getHeader().size() <= index || index < 0) {
            throw new DataFrameRuntimeException(String.format("invalid column index '%d'", index));
        }
        if (!this.isCompatible(value, index)) {
            throw new DataFrameRuntimeException(String.format("the value (%s) is not compatible with this column (%s)", value.getClass(), index));
        }
        this.setValue(index, value);
    }

    protected abstract void setValue(int var1, V var2);
}

