/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.Header;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.StringUtil;
import de.unknownreality.dataframe.csv.CSVRuntimeException;
import de.unknownreality.dataframe.csv.CSVSettings;
import de.unknownreality.dataframe.io.DataWriter;
import de.unknownreality.dataframe.io.FileFormat;
import de.unknownreality.dataframe.io.ReadFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class CSVWriter
extends DataWriter {
    private CSVSettings settings;

    protected CSVWriter(CSVSettings settings) {
        this.settings = settings;
    }

    @Override
    public void write(OutputStream os, DataContainer<?, ?> dataContainer) {
        if (this.settings.isGzip()) {
            try {
                os = new GZIPOutputStream(os);
            }
            catch (IOException e) {
                throw new CSVRuntimeException("error creating gzip output stream", e);
            }
        }
        super.write(os, dataContainer);
    }

    @Override
    public void write(BufferedWriter bufferedWriter, DataContainer<?, ?> dataContainer) {
        try {
            this.writeHeader(bufferedWriter, (Header<?>)dataContainer.getHeader());
            for (Row row : dataContainer) {
                this.writeRow(bufferedWriter, row);
            }
        }
        catch (Exception e) {
            throw new CSVRuntimeException("error writing csv", e);
        }
    }

    public void writeHeader(BufferedWriter bufferedWriter, Header<?> header) throws Exception {
        if (!this.settings.isContainsHeader()) {
            return;
        }
        if (this.settings.getHeaderPrefix() != null) {
            bufferedWriter.write(this.settings.getHeaderPrefix());
        }
        for (int i = 0; i < header.size(); ++i) {
            bufferedWriter.write(header.get(i).toString());
            if (i >= header.size() - 1) continue;
            bufferedWriter.write(this.settings.getSeparator());
        }
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    public void writeRow(BufferedWriter bufferedWriter, Row row) throws Exception {
        char separator = this.settings.getSeparator();
        for (int i = 0; i < row.size(); ++i) {
            Object v = row.get(i);
            String s = v.toString();
            boolean putInQuotes = false;
            boolean escapeQuotes = false;
            if (v instanceof String) {
                char[] chars = s.toCharArray();
                for (int j = 0; j < chars.length; ++j) {
                    char c = chars[j];
                    if (c == separator || c == '\'') {
                        putInQuotes = true;
                        continue;
                    }
                    if (c != '\"') continue;
                    putInQuotes = true;
                    escapeQuotes = true;
                }
            }
            boolean bl = putInQuotes = putInQuotes || this.settings.isQuoteStrings() && v instanceof String;
            if (putInQuotes) {
                s = escapeQuotes ? StringUtil.putInQuotes(s, Character.valueOf('\"')) : "\"" + s + "\"";
            }
            bufferedWriter.write(s);
            if (i >= row.size() - 1) continue;
            bufferedWriter.write(this.settings.getSeparator());
        }
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    @Override
    public void write(File file, DataContainer<?, ?> dataContainer) {
        if (this.settings.isGzip()) {
            try (GZIPOutputStream outputStream = new GZIPOutputStream(new FileOutputStream(file));){
                this.write(new BufferedWriter(new OutputStreamWriter(outputStream)), dataContainer);
                return;
            }
            catch (IOException e) {
                throw new CSVRuntimeException(String.format("error writing file '%s'", file.getAbsolutePath()), e);
            }
        }
        super.write(file, dataContainer);
    }

    @Override
    public Map<String, String> getSettings(DataFrame dataFrame) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("separator", Character.toString(this.settings.getSeparator()));
        attributes.put("headerPrefix", this.settings.getHeaderPrefix());
        attributes.put("containsHeader", Boolean.toString(this.settings.isContainsHeader()));
        attributes.put("gzip", Boolean.toString(this.settings.isGzip()));
        return attributes;
    }

    @Override
    public List<DataFrameColumn> getMetaColumns(DataFrame dataFrame) {
        return new ArrayList<DataFrameColumn>(dataFrame.getColumns());
    }

    @Override
    public ReadFormat getReadFormat() {
        return FileFormat.CSV;
    }
}

