/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.csv.CSVSettings;
import de.unknownreality.dataframe.csv.CSVWriter;
import de.unknownreality.dataframe.io.WriterBuilder;

public class CSVWriterBuilder
implements WriterBuilder<CSVWriter> {
    private char separator = (char)9;
    private String headerPrefix = "";
    private boolean containsHeader = true;
    private boolean gzip = false;
    private boolean quoteStrings = false;

    private CSVWriterBuilder() {
    }

    public static CSVWriterBuilder create() {
        return new CSVWriterBuilder();
    }

    public CSVWriterBuilder withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public CSVWriterBuilder withHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
        return this;
    }

    public CSVWriterBuilder withHeader(boolean header) {
        this.containsHeader = header;
        return this;
    }

    @Deprecated
    public CSVWriterBuilder containsHeader(boolean header) {
        this.containsHeader = header;
        return this;
    }

    public CSVWriterBuilder quoteStrings(boolean quoteStrings) {
        this.quoteStrings = quoteStrings;
        return this;
    }

    public CSVWriterBuilder useGzip(boolean gzip) {
        this.gzip = gzip;
        return this;
    }

    @Override
    public CSVWriter build() {
        CSVSettings settings = new CSVSettings();
        settings.setSeparator(this.separator);
        settings.setHeaderPrefix(this.headerPrefix);
        settings.setContainsHeader(this.containsHeader);
        settings.setGzip(this.gzip);
        settings.setQuoteStrings(this.quoteStrings);
        return new CSVWriter(settings);
    }
}

