/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter;

import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.KeyValueGetter;
import de.unknownreality.dataframe.filter.FilterPredicate;
import java.util.function.BiFunction;
import java.util.regex.Pattern;

public class LikePredicate
extends FilterPredicate {
    public static final char WILDCARD_CHAR = '_';
    private static final BiFunction<String, String, Boolean> STARTS_WITH_FN = (query, value) -> LikePredicate.compareStartsWith(value, query);
    private static final BiFunction<String, String, Boolean> ENDS_WITH_FN = (query, value) -> LikePredicate.compareEndsWith(value, query);
    private static final BiFunction<Pattern, String, Boolean> CONTAINS_FN = (pattern, value) -> LikePredicate.compareContains(value, pattern);
    private static final BiFunction<String, String, Boolean> EQUALS_FN = (query, value) -> LikePredicate.compareEquals(value, query);
    private static final String STARTS_WITH_FORMAT = "%s LIKE '%s%%'";
    private static final String ENDS_WITH_FORMAT = "%s LIKE '%%%s'";
    private static final String CONTAINS_FORMAT = "%s LIKE '%%%s%%'";
    private static final String EQUALS_FORMAT = "%s LIKE '%s'";
    private final String query;
    private final String headerName;
    private Type type;
    private BiFunction<String, String, Boolean> compareFunction;
    private String format;
    private Pattern containsPattern;

    public LikePredicate(String headerName, String query) {
        this.type = LikePredicate.findQueryType(query);
        this.query = LikePredicate.removeQueryChars(query, this.type).toLowerCase();
        this.headerName = headerName;
        this.setup();
    }

    public LikePredicate(String headerName, String query, Type type) {
        this.headerName = headerName;
        this.query = query.toLowerCase();
        this.type = type;
        this.setup();
    }

    public static Type findQueryType(String query) {
        char c1 = query.charAt(0);
        char c2 = query.charAt(query.length() - 1);
        if (c1 == '%' && c2 == '%') {
            return Type.Contains;
        }
        if (c1 == '%') {
            return Type.EndsWith;
        }
        if (c2 == '%') {
            return Type.StartsWith;
        }
        return Type.Equals;
    }

    public static String removeQueryChars(String query, Type type) {
        switch (type) {
            case Contains: {
                return query.substring(1, query.length() - 1);
            }
            case StartsWith: {
                return query.substring(0, query.length() - 1);
            }
            case EndsWith: {
                return query.substring(1);
            }
        }
        return query;
    }

    private static boolean compareStartsWith(String value, String query) {
        int ql = query.length();
        int l = value.length();
        for (int i = 0; i < l && i != ql; ++i) {
            char cv = value.charAt(i);
            char cq = query.charAt(i);
            if (cq == '_' || cv == cq) continue;
            return false;
        }
        return true;
    }

    private static boolean compareEndsWith(String value, String query) {
        int j = query.length() - 1;
        for (int i = value.length() - 1; i >= 0 && j != -1; --i) {
            char cq;
            char cv = value.charAt(i);
            if ((cq = query.charAt(j--)) == '_' || cv == cq) continue;
            return false;
        }
        return true;
    }

    private static boolean compareEquals(String value, String query) {
        int ql;
        int vl = value.length();
        if (vl != (ql = query.length())) {
            return false;
        }
        int l = value.length();
        for (int i = 0; i < l; ++i) {
            char cv = value.charAt(i);
            char cq = query.charAt(i);
            if (cq == '_' || cv == cq) continue;
            return false;
        }
        return true;
    }

    private static boolean compareContains(String value, Pattern pattern) {
        return pattern.matcher(value).find();
    }

    private static Pattern createContainsPattern(String query) {
        int l = query.length();
        if (l == 0) {
            return Pattern.compile("");
        }
        StringBuilder sb = new StringBuilder(2 * l);
        for (int i = 0; i < l; ++i) {
            char c = query.charAt(i);
            if (c == '[' || c == ']' || c == '(' || c == ')' || c == '{' || c == '}' || c == '.' || c == '*' || c == '+' || c == '?' || c == '$' || c == '^' || c == '|' || c == '#' || c == '\\') {
                sb.append("\\");
                sb.append(c);
                continue;
            }
            if (c == '_') {
                sb.append(".");
                continue;
            }
            sb.append(c);
        }
        return Pattern.compile(sb.toString());
    }

    private void setup() {
        switch (this.type) {
            case Contains: {
                this.containsPattern = LikePredicate.createContainsPattern(this.query);
                this.compareFunction = (q, v) -> LikePredicate.compareContains(v, this.containsPattern);
                this.format = CONTAINS_FORMAT;
                break;
            }
            case EndsWith: {
                this.compareFunction = ENDS_WITH_FN;
                this.format = ENDS_WITH_FORMAT;
                break;
            }
            case StartsWith: {
                this.compareFunction = STARTS_WITH_FN;
                this.format = STARTS_WITH_FORMAT;
                break;
            }
            default: {
                this.compareFunction = EQUALS_FN;
                this.format = EQUALS_FORMAT;
            }
        }
    }

    @Override
    public boolean valid(KeyValueGetter<String, ?> kv) {
        Object v = kv.get(this.headerName);
        if (Values.NA.isNA(v)) {
            return false;
        }
        String value = v.toString();
        value = value.toLowerCase();
        return this.compareFunction.apply(this.query, value);
    }

    @Override
    public String toString() {
        return String.format(this.format, this.headerName, this.query);
    }

    public static enum Type {
        StartsWith,
        EndsWith,
        Contains,
        Equals;

    }
}

