/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group;

import de.unknownreality.dataframe.ColumnTypeMap;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.DefaultDataFrame;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.group.GroupRow;
import de.unknownreality.dataframe.group.aggr.AggregateFunction;
import java.util.ArrayList;
import java.util.List;

public class DataGrouping
extends DefaultDataFrame {
    public static final String GROUP_INDEX = "%group_index%";
    private DataGroup[] groups;

    public DataGrouping(List<DataGroup> groups, DataFrameColumn ... groupColumns) {
        this.addIndex(GROUP_INDEX, groupColumns);
        this.groups = new DataGroup[groups.size()];
        groups.toArray(this.groups);
        for (DataFrameColumn col : groupColumns) {
            this.addColumn(col);
        }
        for (int i = 0; i < groups.size(); ++i) {
            this.groups[i] = groups.get(i);
            this.append(groups.get(i).getGroupValues().getValues());
        }
    }

    public <T extends Comparable<T>> DataGrouping aggregate(String columnName, AggregateFunction<T> fun) {
        return this.agg(columnName, fun);
    }

    public <T extends Comparable<T>> DataGrouping agg(String columnName, AggregateFunction<T> fun) {
        DataFrameColumn dataFrameColumn;
        Class colType;
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            Comparable v = (Comparable)fun.aggregate(this.getRow(i).getGroup());
            values.add(v);
        }
        Class vType = null;
        for (Comparable comparable : values) {
            if (comparable == null) continue;
            vType = comparable.getClass();
            break;
        }
        if ((colType = ColumnTypeMap.get(vType = vType == null ? String.class : vType)) == null) {
            throw new DataFrameRuntimeException(String.format("no column type found for value type '%s'", vType.getCanonicalName()));
        }
        try {
            dataFrameColumn = (DataFrameColumn)colType.newInstance();
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new DataFrameRuntimeException(String.format("error creating instance of column [%s], empty constructor required", colType.getCanonicalName()), e);
        }
        dataFrameColumn.setName(columnName);
        for (Comparable comparable : values) {
            if (comparable == null || Values.NA.isNA(comparable)) {
                dataFrameColumn.appendNA();
                continue;
            }
            dataFrameColumn.append(comparable);
        }
        this.addColumn(dataFrameColumn);
        return this;
    }

    public DataGroup getGroup(int index) {
        return this.groups[index];
    }

    public DataGroup getGroup(DataRow row) {
        return this.getGroup(row.getIndex());
    }

    public GroupRow findByGroupValues(Comparable ... values) {
        return (GroupRow)this.selectFirstRowByIndex(GROUP_INDEX, values);
    }

    @Override
    public GroupRow getRow(int i) {
        return new GroupRow(this.getGroup(i), this, i);
    }
}

