/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Header;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GroupHeader
implements Header<String> {
    private final Map<String, Integer> headerMap = new HashMap<String, Integer>();
    private final List<String> headers = new ArrayList<String>();

    public GroupHeader(String ... columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.headers.add(columns[i]);
            this.headerMap.put(columns[i], i);
        }
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public String get(int index) {
        if (index >= this.headers.size()) {
            throw new DataFrameRuntimeException(String.format("header index out of bounds %d > %d", index, this.headers.size() - 1));
        }
        return this.headers.get(index);
    }

    @Override
    public boolean contains(String groupValueName) {
        return this.headerMap.containsKey(groupValueName);
    }

    @Override
    public int getIndex(String name) {
        Integer index = this.headerMap.get(name);
        if (index == null) {
            throw new DataFrameRuntimeException(String.format("column header name not found '%s'", name));
        }
        return index;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            final Iterator<String> it;
            {
                this.it = GroupHeader.this.headers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported");
            }

            @Override
            public String next() {
                return this.it.next();
            }
        };
    }
}

