/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group.impl;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.group.DataGrouping;
import de.unknownreality.dataframe.group.GroupUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TreeGroupUtil
implements GroupUtil {
    @Override
    public DataGrouping groupBy(DataFrame df, String ... columns) {
        ArrayList<DataGroup> groupList = new ArrayList<DataGroup>();
        DataFrameHeader header = df.getHeader().copy();
        GroupNode root = new GroupNode(null);
        DataFrameColumn[] dfColumns = new DataFrameColumn[df.getHeader().size()];
        df.getColumns().toArray(dfColumns);
        int[] groupColumnIndices = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            groupColumnIndices[i] = header.getIndex(columns[i]);
        }
        Comparable[] groupValues = new Comparable[columns.length];
        for (int i = 0; i < df.size(); ++i) {
            this.addRec(groupList, root, 0, columns, groupColumnIndices, groupValues, header, df, i);
        }
        root.clear();
        return new DataGrouping(groupList, TreeGroupUtil.createGroupColumns(df, columns));
    }

    private void addRec(List<DataGroup> groups, GroupNode node, int index, String[] groupColumns, int[] groupColumnIndices, Comparable[] groupValues, DataFrameHeader header, DataFrame df, int rowIndex) {
        Comparable value;
        if (index == groupColumns.length) {
            if (!node.hasGroup()) {
                DataGroup group = new DataGroup(groupColumns, groupValues);
                group.set(header.copy());
                groups.add(group);
                node.setGroup(group);
            }
            node.addRow(df, rowIndex);
            return;
        }
        groupValues[index] = value = df.getValue(groupColumnIndices[index], rowIndex);
        GroupNode child = node.getChild(value);
        if (child == null) {
            child = new GroupNode(value);
            node.addChild(child);
        }
        this.addRec(groups, child, index + 1, groupColumns, groupColumnIndices, groupValues, header, df, rowIndex);
    }

    private static DataFrameColumn[] createGroupColumns(DataFrame df, String ... columns) {
        DataFrameColumn[] groupColumns = new DataFrameColumn[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            DataFrameColumn orgCol = df.getColumn(columns[i]);
            groupColumns[i] = orgCol.copyEmpty();
        }
        return groupColumns;
    }

    private class GroupNode {
        private Comparable value;
        private HashMap<Comparable, GroupNode> children;
        private DataGroup dataGroup;

        public GroupNode(Comparable value) {
            this.value = value;
        }

        public void clear() {
            if (this.children != null) {
                this.children.clear();
            }
            if (this.dataGroup != null) {
                this.dataGroup = null;
            }
        }

        private HashMap<Comparable, GroupNode> getChildrenMap() {
            if (this.children == null) {
                this.children = new HashMap();
            }
            return this.children;
        }

        public Comparable getValue() {
            return this.value;
        }

        public void addChild(GroupNode child) {
            this.getChildrenMap().put(child.getValue(), child);
        }

        public GroupNode getChild(Comparable value) {
            return this.getChildrenMap().get(value);
        }

        public void addRow(DataFrame df, int rowIndex) {
            this.dataGroup.append(df, rowIndex);
        }

        public void setGroup(DataGroup group) {
            this.dataGroup = group;
        }

        public boolean hasGroup() {
            return this.dataGroup != null;
        }
    }
}

