/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.index.interval;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.column.NumberColumn;
import de.unknownreality.dataframe.index.Index;
import de.unknownreality.dataframe.index.interval.Interval;
import de.unknownreality.dataframe.index.interval.IntervalSearchTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntervalIndex
implements Index {
    private Map<Integer, Interval> intervalMap = new HashMap<Integer, Interval>();
    private IntervalSearchTree<Integer> intervalSearchTree = new IntervalSearchTree();
    private NumberColumn<?, ?> startColumn;
    private NumberColumn<?, ?> endColumn;
    private String name;

    public static IntervalIndex create(DataFrame dataFrame, String name, String startColumn, String endColumn) {
        return new IntervalIndex(name, dataFrame.getNumberColumn(startColumn), dataFrame.getNumberColumn(endColumn));
    }

    public static IntervalIndex create(String name, NumberColumn<?, ?> startColumn, NumberColumn<?, ?> endColumn) {
        return new IntervalIndex(name, startColumn, endColumn);
    }

    public IntervalIndex(String name, NumberColumn<?, ?> startColumn, NumberColumn<?, ?> endColumn) {
        this.name = name;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    @Override
    public void update(DataRow dataRow) {
        Interval interval;
        if (this.intervalMap.containsKey(dataRow.getIndex())) {
            interval = this.intervalMap.get(dataRow.getIndex());
            this.intervalSearchTree.remove(interval);
        }
        interval = this.createInterval(dataRow);
        this.intervalMap.put(dataRow.getIndex(), interval);
        this.intervalSearchTree.add(interval, dataRow.getIndex());
    }

    @Override
    public void remove(DataRow dataRow) {
        if (this.intervalMap.containsKey(dataRow.getIndex())) {
            Interval interval = this.intervalMap.get(dataRow.getIndex());
            this.intervalSearchTree.remove(interval);
        }
    }

    private Interval createInterval(DataRow row) {
        return new Interval(row.getNumber(this.startColumn.getName()), row.getNumber(this.endColumn.getName()));
    }

    @Override
    public Collection<Integer> find(Comparable ... values) {
        if (values.length == 1) {
            if (!(values[0] instanceof Number)) {
                throw new DataFrameRuntimeException("stab value must be a number for interval search");
            }
            return this.intervalSearchTree.stab((Number)((Object)values[0]));
        }
        if (values.length != 2) {
            throw new DataFrameRuntimeException("start and end values are required for interval search");
        }
        if (!(values[0] instanceof Number) || !(values[1] instanceof Number)) {
            throw new DataFrameRuntimeException("start and end values must be numbers for interval search");
        }
        return this.intervalSearchTree.searchAll((Number)((Object)values[0]), (Number)((Object)values[1]));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setUnique(boolean unique) {
        throw new DataFrameRuntimeException("unique is not supported by interval indices");
    }

    @Override
    public boolean containsColumn(DataFrameColumn column) {
        return this.startColumn == column || this.endColumn == column;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public List<DataFrameColumn> getColumns() {
        ArrayList<DataFrameColumn> columns = new ArrayList<DataFrameColumn>();
        columns.add(this.startColumn);
        columns.add(this.endColumn);
        return columns;
    }

    @Override
    public void clear() {
        this.intervalMap.clear();
        this.intervalSearchTree.clear();
    }

    @Override
    public void replaceColumn(DataFrameColumn existing, DataFrameColumn replacement) {
        if (!(replacement instanceof NumberColumn)) {
            throw new DataFrameRuntimeException("only number columns are supported by interval indices");
        }
        this.clear();
        if (this.startColumn == existing) {
            this.startColumn = (NumberColumn)replacement;
        }
        if (this.endColumn == existing) {
            this.endColumn = (NumberColumn)replacement;
        }
        for (int i = 0; i < this.startColumn.size(); ++i) {
            Interval interval = new Interval((Number)this.startColumn.get(i), (Number)this.endColumn.get(i));
            this.intervalMap.put(i, interval);
            this.intervalSearchTree.add(interval, i);
        }
    }
}

