/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.index.interval;

import de.unknownreality.dataframe.index.interval.Interval;

public class IntervalNode<T> {
    private Interval interval;
    private T value;
    private IntervalNode<T> left;
    private IntervalNode<T> right;
    private long subtreeSize;
    private Number max;

    IntervalNode(Interval interval, T value) {
        this.interval = interval;
        this.subtreeSize = 1L;
        this.max = interval.high;
        this.value = value;
    }

    public IntervalNode<T> getRight() {
        return this.right;
    }

    public IntervalNode<T> getLeft() {
        return this.left;
    }

    public void setRight(IntervalNode<T> right) {
        this.right = right;
    }

    public void setLeft(IntervalNode<T> left) {
        this.left = left;
    }

    public T getValue() {
        return this.value;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public Number getMax() {
        return this.max;
    }

    public long getSubtreeSize() {
        return this.subtreeSize;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setSubtreeSize(long subtreeSize) {
        this.subtreeSize = subtreeSize;
    }

    public int getSubtreeHeight() {
        int l = Integer.MIN_VALUE;
        int r = Integer.MIN_VALUE;
        if (this.left != null) {
            l = this.left.getSubtreeHeight();
        }
        if (this.right != null) {
            r = this.right.getSubtreeHeight();
        }
        return Math.max(1, Math.max(l, r));
    }
}

