/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.index.interval;

import de.unknownreality.dataframe.common.NumberUtil;
import de.unknownreality.dataframe.index.interval.Interval;
import de.unknownreality.dataframe.index.interval.IntervalNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class IntervalSearchTree<T> {
    private IntervalNode<T> root;
    private Random random = new Random();

    public long getSize() {
        return this.root.getSubtreeSize();
    }

    public int getHeight() {
        return this.root.getSubtreeHeight();
    }

    public boolean contains(Interval interval) {
        return this.find(interval) != null;
    }

    public T find(Interval interval) {
        return this.find(this.root, interval);
    }

    private T find(IntervalNode<T> node, Interval interval) {
        if (node == null) {
            return null;
        }
        int c = interval.compareTo(node.getInterval());
        if (c < 0) {
            return this.find(node.getLeft(), interval);
        }
        if (c > 0) {
            return this.find(node.getRight(), interval);
        }
        return node.getValue();
    }

    public void add(Interval interval, T value) {
        this.root = this.recInsert(this.root, interval, value);
    }

    private IntervalNode<T> recInsert(IntervalNode<T> node, Interval interval, T value) {
        if (node == null) {
            return new IntervalNode<T>(interval, value);
        }
        if (this.random.nextDouble() * (double)node.getSubtreeSize() <= 1.0) {
            return this.rootInsert(node, interval, value);
        }
        int c = interval.compareTo(node.getInterval());
        if (c < 0) {
            node.setLeft(this.recInsert(node.getLeft(), interval, value));
        } else {
            node.setRight(this.recInsert(node.getRight(), interval, value));
        }
        this.updateNode(node);
        return node;
    }

    private IntervalNode<T> rootInsert(IntervalNode<T> node, Interval interval, T value) {
        if (node == null) {
            return new IntervalNode<T>(interval, value);
        }
        int c = interval.compareTo(node.getInterval());
        if (c < 0) {
            node.setLeft(this.recInsert(node.getLeft(), interval, value));
            node = this.rotateRight(node);
        } else {
            node.setRight(this.recInsert(node.getRight(), interval, value));
            node = this.rotateLeft(node);
        }
        return node;
    }

    private IntervalNode<T> rotateRight(IntervalNode<T> node) {
        IntervalNode<T> tmp = node.getLeft();
        node.setLeft(tmp.getRight());
        tmp.setRight(node);
        this.updateNode(node);
        this.updateNode(tmp);
        return tmp;
    }

    private IntervalNode<T> rotateLeft(IntervalNode<T> node) {
        IntervalNode<T> tmp = node.getRight();
        node.setRight(tmp.getLeft());
        tmp.setLeft(node);
        this.updateNode(node);
        this.updateNode(tmp);
        return tmp;
    }

    private void updateNode(IntervalNode node) {
        if (node == null) {
            return;
        }
        this.updateMax(node);
        this.updateSubtreeSize(node);
    }

    private void updateSubtreeSize(IntervalNode node) {
        long size = 1L;
        if (node.getLeft() != null) {
            size += node.getLeft().getSubtreeSize();
        }
        if (node.getRight() != null) {
            size += node.getRight().getSubtreeSize();
        }
        node.setSubtreeSize(size);
    }

    private void updateMax(IntervalNode node) {
        Number max = node.getInterval().high;
        Number maxL = node.getLeft() != null ? (Number)node.getLeft().getMax() : (Number)Double.NEGATIVE_INFINITY;
        Number maxR = node.getRight() != null ? (Number)node.getRight().getMax() : (Number)Double.NEGATIVE_INFINITY;
        max = NumberUtil.max(max, NumberUtil.max(maxL, maxR));
        node.setMax(max);
    }

    public void remove(Interval interval) {
        this.root = this.remove(this.root, interval);
    }

    private IntervalNode<T> remove(IntervalNode<T> node, Interval interval) {
        if (node == null) {
            return null;
        }
        int c = interval.compareTo(node.getInterval());
        if (c < 0) {
            node.setLeft(this.remove(node.getLeft(), interval));
        } else if (c > 0) {
            node.setRight(this.remove(node.getRight(), interval));
        } else {
            node = this.joinLeftRight(node.getLeft(), node.getRight());
        }
        this.updateNode(node);
        return node;
    }

    private IntervalNode<T> joinLeftRight(IntervalNode<T> a, IntervalNode<T> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (this.random.nextDouble() * (double)(a.getSubtreeSize() + b.getSubtreeSize()) < (double)a.getSubtreeSize()) {
            a.setRight(this.joinLeftRight(a.getRight(), b));
            this.updateNode(a);
            return a;
        }
        a.setRight(this.joinLeftRight(a, b.getLeft()));
        this.updateNode(b);
        return b;
    }

    public List<T> searchAll(Interval interval) {
        ArrayList result = new ArrayList();
        this.recSearchAll(this.root, interval, result);
        return result;
    }

    public List<T> searchAll(Number low, Number high) {
        ArrayList result = new ArrayList();
        this.recSearchAll(this.root, new Interval(low, high), result);
        return result;
    }

    private boolean recSearchAll(IntervalNode<T> node, Interval interval, List<T> result) {
        if (node == null) {
            return false;
        }
        boolean found = false;
        if (interval.intersects(node.getInterval())) {
            result.add(node.getValue());
            found = true;
        }
        boolean foundLeft = false;
        if (node.getLeft() != null && NumberUtil.le(interval.low, node.getLeft().getMax())) {
            foundLeft = this.recSearchAll(node.getLeft(), interval, result);
        }
        if (foundLeft || node.getLeft() == null || NumberUtil.gt(interval.low, node.getLeft().getMax())) {
            found |= this.recSearchAll(node.getRight(), interval, result);
        }
        return found || foundLeft;
    }

    public List<T> stab(Number value) {
        ArrayList result = new ArrayList();
        this.recStab(this.root, value, result);
        return result;
    }

    private boolean recStab(IntervalNode<T> node, Number value, List<T> result) {
        if (node == null) {
            return false;
        }
        if (NumberUtil.gt(value, node.getMax())) {
            return false;
        }
        boolean found = false;
        if (node.getInterval().contains(value)) {
            result.add(node.getValue());
            found = true;
        }
        boolean foundLeft = false;
        if (node.getLeft() != null && NumberUtil.le(value, node.getLeft().getMax())) {
            foundLeft = this.recStab(node.getLeft(), value, result);
        }
        if (foundLeft || node.getLeft() == null || NumberUtil.gt(value, node.getLeft().getMax())) {
            found |= this.recStab(node.getRight(), value, result);
        }
        return found || foundLeft;
    }

    public void clear() {
        this.root = null;
    }
}

