/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.io;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.RowIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BufferedStreamIterator<R extends Row>
implements RowIterator<R> {
    private static final Logger log = LoggerFactory.getLogger(BufferedStreamIterator.class);
    private final BufferedReader reader;
    private R next;

    public BufferedStreamIterator(InputStream stream) {
        if (stream == null) {
            throw new DataFrameRuntimeException("input stream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    public BufferedStreamIterator(BufferedReader reader) {
        if (reader == null) {
            throw new DataFrameRuntimeException("reader is null");
        }
        this.reader = reader;
    }

    protected void loadNext() {
        this.next = this.getNext();
    }

    protected String getLine() throws IOException {
        return this.reader.readLine();
    }

    public void skip(int rows) {
        for (int i = 0; i < rows; ++i) {
            try {
                this.getLine();
                continue;
            }
            catch (IOException e) {
                log.error("error reading file:{}", (Throwable)e);
                this.close();
            }
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            log.error("error closing stream", (Throwable)e);
        }
    }

    protected abstract R getNext();

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public R next() {
        if (this.next == null) {
            throw new NoSuchElementException("no next element found");
        }
        R row = this.next;
        this.next = this.getNext();
        if (this.next == null) {
            this.close();
        }
        return row;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported by this iterator");
    }
}

