/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.io;

import de.unknownreality.dataframe.ColumnTypeMap;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.column.StringColumn;

public class ColumnInformation {
    private boolean autodetect;
    private String name;
    private int index;
    private Class<? extends DataFrameColumn> columnType;

    public ColumnInformation(int index, String name, Class<? extends Comparable> type) {
        this.index = index;
        this.name = name;
        this.columnType = ColumnTypeMap.get(type);
        if (this.columnType == null) {
            throw new DataFrameRuntimeException(String.format("no column type found for value type '%s'", type));
        }
        this.autodetect = false;
    }

    public ColumnInformation(int index, String name) {
        this.index = index;
        this.name = name;
        this.autodetect = false;
    }

    public void setColumnType(Class<? extends DataFrameColumn> columnType) {
        this.columnType = columnType;
    }

    public ColumnInformation(int index, String name, boolean autodetect) {
        this.index = index;
        this.name = name;
        this.columnType = StringColumn.class;
        this.autodetect = autodetect;
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<? extends DataFrameColumn> getColumnType() {
        return this.columnType;
    }
}

