/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join.impl;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinInfo;
import de.unknownreality.dataframe.join.JoinOperation;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.join.impl.JoinOperationUtil;
import de.unknownreality.dataframe.join.impl.JoinTree;

public class InnerJoin
implements JoinOperation {
    @Override
    public JoinedDataFrame join(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        JoinInfo joinInfo = JoinOperationUtil.createJoinInfo(dfA, dfB, joinColumns, joinSuffixA, joinSuffixB);
        int[] joinIndicesA = JoinOperationUtil.getJoinIndices(dfA, joinInfo);
        int[] joinIndicesB = JoinOperationUtil.getJoinIndices(dfB, joinInfo);
        int joinSize = joinInfo.getHeader().size();
        JoinedDataFrame joinedDataFrame = new JoinedDataFrame(joinInfo);
        joinedDataFrame.set(joinInfo.getHeader());
        JoinTree joinTree = new JoinTree(JoinTree.LeafMode.All, dfA, dfB, joinColumns);
        for (JoinTree.JoinNode node : joinTree.getSavedLeafs()) {
            if (node.getIndicesA() == null) continue;
            for (Integer rowA : node.getIndicesA()) {
                DataRow dataRowA = dfA.getRow(rowA);
                if (node.getIndicesB() == null || node.getIndicesB().isEmpty()) continue;
                JoinOperationUtil.appendGroupJoinedRows(node.getIndicesB(), dfB, dataRowA, joinIndicesA, joinIndicesB, joinSize, joinedDataFrame);
            }
        }
        return joinedDataFrame;
    }
}

