/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join.impl;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.join.JoinColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JoinTree {
    Set<JoinNode> savedLeafs = new LinkedHashSet<JoinNode>();
    private JoinNode root = new JoinNode(null);
    private boolean saveLeafsA;
    private boolean saveLeafsB;
    private int[] colIndicesA;
    private int[] colIndicesB;

    public JoinTree(LeafMode mode, DataFrame dfA, DataFrame dfB, JoinColumn ... columns) {
        int i = 0;
        this.colIndicesA = new int[columns.length];
        this.colIndicesB = new int[columns.length];
        for (JoinColumn column : columns) {
            int idx = i++;
            this.colIndicesA[idx] = dfA.getHeader().getIndex(column.getColumnA());
            this.colIndicesB[idx] = dfB.getHeader().getIndex(column.getColumnB());
        }
        this.saveLeafsA = true;
        this.saveLeafsB = mode == LeafMode.All;
        this.setA(dfA);
        this.setB(dfB);
    }

    private void setA(DataFrame df) {
        this.set(df, this.colIndicesA, true, this.saveLeafsA);
    }

    private void setB(DataFrame df) {
        this.set(df, this.colIndicesB, false, this.saveLeafsB);
    }

    private void set(DataFrame df, int[] colIndices, boolean isA, boolean safeLeafs) {
        for (DataRow row : df) {
            Comparable<?>[] values = this.createValues(row, colIndices);
            this.addRec(this.root, 0, values, row.getIndex(), isA, safeLeafs);
        }
    }

    private void addRec(JoinNode node, int index, Comparable<?>[] values, Integer rowIndex, boolean isA, boolean saveLeaf) {
        if (index == values.length) {
            if (saveLeaf) {
                this.savedLeafs.add(node);
            }
            if (isA) {
                node.addIndexA(rowIndex);
            } else {
                node.addIndexB(rowIndex);
            }
            return;
        }
        Comparable<?> value = values[index];
        JoinNode child = node.getChild(value);
        if (child == null) {
            child = new JoinNode(value);
            node.addChild(child);
        }
        this.addRec(child, index + 1, values, rowIndex, isA, saveLeaf);
    }

    private Comparable<?>[] createValues(DataRow dataRow, int[] colIndices) {
        Comparable[] values = new Comparable[colIndices.length];
        for (int i = 0; i < colIndices.length; ++i) {
            values[i] = dataRow.get(colIndices[i]);
        }
        return values;
    }

    public Set<JoinNode> getSavedLeafs() {
        return this.savedLeafs;
    }

    public class JoinNode {
        private Comparable<?> value;
        private HashMap<Comparable<?>, JoinNode> children;
        private List<Integer> indicesA;
        private List<Integer> indicesB;

        public JoinNode(Comparable<?> value) {
            this.value = value;
        }

        public void clear() {
            if (this.children != null) {
                this.children.clear();
            }
            if (this.indicesA != null) {
                this.indicesA.clear();
            }
            if (this.indicesB != null) {
                this.indicesB.clear();
            }
        }

        private HashMap<Comparable<?>, JoinNode> getChildrenMap() {
            if (this.children == null) {
                this.children = new HashMap();
            }
            return this.children;
        }

        public Comparable<?> getValue() {
            return this.value;
        }

        public void addChild(JoinNode child) {
            this.getChildrenMap().put(child.getValue(), child);
        }

        public JoinNode getChild(Comparable<?> value) {
            return this.getChildrenMap().get(value);
        }

        public void removeChild(JoinNode child) {
            this.removeChild(child.getValue());
        }

        public void removeChild(Comparable<?> value) {
            this.getChildrenMap().remove(value);
        }

        public void addIndexA(Integer index) {
            if (this.indicesA == null) {
                this.indicesA = new ArrayList<Integer>();
            }
            this.getIndicesA().add(index);
        }

        public void addIndexB(Integer index) {
            if (this.indicesB == null) {
                this.indicesB = new ArrayList<Integer>();
            }
            this.getIndicesB().add(index);
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public Collection<Integer> getIndicesA() {
            return this.indicesA;
        }

        public Collection<Integer> getIndicesB() {
            return this.indicesB;
        }
    }

    public static enum LeafMode {
        All,
        FirstOnly;

    }
}

