/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.print;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.header.BasicTypeHeader;
import de.unknownreality.dataframe.io.DataWriter;
import de.unknownreality.dataframe.io.ReadFormat;
import de.unknownreality.dataframe.print.ColumnPrintSettings;
import de.unknownreality.dataframe.print.DefaultNumberFormatter;
import de.unknownreality.dataframe.print.DefaultValueFormatter;
import de.unknownreality.dataframe.print.ValueFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Printer
extends DataWriter {
    private String topLeftCorner = "\u250c";
    private String topRightCorner = "\u2510";
    private String bottomLeftCorner = "\u2514";
    private String bottomRightCorner = "\u2518";
    private String topLine = "\u2500";
    private String bottomLine = "\u2500";
    private String leftLine = "\u2502";
    private String rightLine = "\u2502";
    private String tLeft = "\u2524";
    private String tRight = "\u251c";
    private String tTop = "\u2534";
    private String tBottom = "\u252c";
    private String innerVerticalLine = "\u2502";
    private String innerHorizontalLine = "\u2500";
    private String innerCrossConnection = "\u253c";
    private int defaultColumnWidth = 12;
    private int defaultMaxContentWidth = 10;
    private int maxAutoWidth = 500;
    private Map<Object, ColumnPrintSettings> columnSettings = new HashMap<Object, ColumnPrintSettings>();
    private ValueFormatter defaultValueFormatter = new DefaultValueFormatter();
    private ValueFormatter defaultHeaderFormatter = (v, m) -> "#" + v.toString();
    private ValueFormatter defaultNumberFormatter = new DefaultNumberFormatter();

    @Override
    public void write(BufferedWriter writer, DataContainer<?, ?> dataContainer) {
        try {
            ColumnPrintSettings[] settings = this.createPrintSettings(dataContainer);
            ColumnWidth[] columnWidths = this.createColumnWidth(dataContainer, settings);
            this.writeHeader(dataContainer, writer, settings, columnWidths);
            StringBuilder contentLineSb = new StringBuilder();
            StringBuilder topLineSb = new StringBuilder();
            StringBuilder lastLineSb = new StringBuilder();
            Iterator it = dataContainer.iterator();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                contentLineSb.setLength(0);
                topLineSb.setLength(0);
                boolean last = !it.hasNext();
                for (int i = 0; i < row.size(); ++i) {
                    ColumnPrintSettings colSettings = settings[i];
                    ColumnWidth columnWidth = columnWidths[i];
                    if (colSettings.getValueFormatter() == null) {
                        colSettings.setValueFormatter(this.getDefaultValueFormatter(row.get(i)));
                    }
                    if (i == 0) {
                        contentLineSb.append(this.leftLine);
                        topLineSb.append(this.tRight);
                        if (last) {
                            lastLineSb.append(this.bottomLeftCorner);
                        }
                    }
                    String content = this.formatContent(colSettings, columnWidth, row, i);
                    contentLineSb.append(content);
                    for (int j = 0; j < content.length(); ++j) {
                        topLineSb.append(this.innerHorizontalLine);
                        if (!last) continue;
                        lastLineSb.append(this.bottomLine);
                    }
                    if (i != row.size() - 1) {
                        contentLineSb.append(this.innerVerticalLine);
                        topLineSb.append(this.innerCrossConnection);
                        if (!last) continue;
                        lastLineSb.append(this.tTop);
                        continue;
                    }
                    contentLineSb.append(this.rightLine);
                    topLineSb.append(this.tLeft);
                    if (!last) continue;
                    lastLineSb.append(this.bottomRightCorner);
                }
                writer.write(topLineSb.toString());
                writer.newLine();
                writer.write(contentLineSb.toString());
                writer.newLine();
                if (!last) continue;
                writer.write(lastLineSb.toString());
                writer.newLine();
            }
            writer.flush();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("error printing data container", e);
        }
    }

    private ColumnWidth[] createColumnWidth(DataContainer<?, ?> dataContainer, ColumnPrintSettings[] columnPrintSetting) {
        ColumnWidth columnWidth;
        ColumnWidth[] widths = new ColumnWidth[dataContainer.getHeader().size()];
        int[] autoWidthCols = new int[widths.length];
        int[] max = new int[widths.length];
        int autoWidthColsCount = 0;
        for (int i = 0; i < widths.length; ++i) {
            ColumnPrintSettings settings = columnPrintSetting[i];
            columnWidth = new ColumnWidth();
            if (!settings.isAutoWidth()) {
                columnWidth.width = settings.getWidth();
                columnWidth.contentWidth = settings.getMaxContentWidth();
            } else {
                max[i] = this.getContentLength(dataContainer.getHeader().get(i), settings);
                autoWidthCols[autoWidthColsCount++] = i;
            }
            widths[i] = columnWidth;
        }
        if (autoWidthColsCount == 0) {
            return widths;
        }
        for (Row row : dataContainer) {
            for (int i = 0; i < autoWidthColsCount; ++i) {
                int c = autoWidthCols[i];
                ColumnPrintSettings settings = columnPrintSetting[c];
                Object v = row.get(c);
                int length = this.getContentLength(v, settings);
                max[i] = Math.max(max[i], length);
            }
        }
        for (int i = 0; i < autoWidthColsCount; ++i) {
            int m;
            columnWidth = widths[autoWidthCols[i]];
            columnWidth.contentWidth = m = Math.min(this.maxAutoWidth, max[i]);
            columnWidth.width = m + 1;
        }
        return widths;
    }

    private int getContentLength(Object v, ColumnPrintSettings printSettings) {
        if (v == null) {
            return 0;
        }
        int length = Values.NA.isNA(v) ? 2 : printSettings.getValueFormatter().format(v, this.maxAutoWidth).length();
        return length;
    }

    private String formatContent(ColumnPrintSettings columnPrintSettings, ColumnWidth columnWidth, Row<?, ?> row, int col) {
        Object v = row.get(col);
        String valueString = v == null ? "" : (Values.NA.isNA(v) ? "NA" : columnPrintSettings.getValueFormatter().format(v, columnWidth.contentWidth));
        String fmt = "%-" + columnWidth.width + "." + columnWidth.contentWidth + "s";
        return String.format(fmt, valueString);
    }

    private String formatHeaderContent(Object header, ColumnPrintSettings columnPrintSettings, ColumnWidth columnWidth) {
        String headerString = columnPrintSettings.getHeaderFormatter().format(header, columnWidth.contentWidth);
        String fmt = "%-" + columnWidth.width + "." + columnWidth.contentWidth + "s";
        return String.format(fmt, headerString);
    }

    protected ColumnPrintSettings[] createPrintSettings(DataContainer<?, ?> dataContainer) {
        ColumnPrintSettings[] settings = new ColumnPrintSettings[dataContainer.getHeader().size()];
        for (int i = 0; i < dataContainer.getHeader().size(); ++i) {
            ColumnPrintSettings columnSettings;
            settings[i] = columnSettings = this.getSettings(dataContainer, i);
        }
        return settings;
    }

    protected void writeHeader(DataContainer<?, ?> dataContainer, BufferedWriter writer, ColumnPrintSettings[] settings, ColumnWidth[] columnWidths) throws IOException {
        StringBuilder contentLineSb = new StringBuilder();
        StringBuilder topLineSb = new StringBuilder();
        topLineSb.append(this.topLeftCorner);
        int cols = dataContainer.getHeader().size();
        int colIdx = 0;
        for (Object header : dataContainer.getHeader()) {
            ColumnWidth columnWidth = columnWidths[colIdx];
            ColumnPrintSettings columnSettings = settings[colIdx];
            if (contentLineSb.length() == 0) {
                contentLineSb.append(this.leftLine);
            }
            String content = this.formatHeaderContent(header, columnSettings, columnWidth);
            contentLineSb.append(content);
            for (int i = 0; i < content.length(); ++i) {
                topLineSb.append(this.topLine);
            }
            if (colIdx < cols - 1) {
                contentLineSb.append(this.innerVerticalLine);
                topLineSb.append(this.tBottom);
            } else {
                topLineSb.append(this.topRightCorner);
                contentLineSb.append(this.rightLine);
            }
            ++colIdx;
        }
        writer.write(topLineSb.toString());
        writer.newLine();
        writer.write(contentLineSb.toString());
        writer.newLine();
    }

    private ColumnPrintSettings getSettings(DataContainer<?, ?> dataContainer, int colIdx) {
        Object header = dataContainer.getHeader().get(colIdx);
        if (!this.columnSettings.containsKey(header)) {
            return this.getDefaultSettings(dataContainer, colIdx);
        }
        ColumnPrintSettings settings = this.columnSettings.get(header);
        if (settings.getValueFormatter() == null) {
            settings.setValueFormatter(this.getDefaultValueFormatter(dataContainer, colIdx));
        }
        if (settings.getHeaderFormatter() == null) {
            settings.setHeaderFormatter(this.getDefaultHeaderFormatter(dataContainer, colIdx));
        }
        if (settings.getWidth() == null) {
            settings.setWidth(this.defaultColumnWidth);
        }
        if (settings.getMaxContentWidth() == null) {
            settings.setMaxContentWidth(this.defaultMaxContentWidth);
        }
        return settings;
    }

    private ColumnPrintSettings getDefaultSettings(DataContainer<?, ?> dataContainer, int colIdx) {
        ColumnPrintSettings defaultSettings = new ColumnPrintSettings();
        defaultSettings.setMaxContentWidth(this.defaultMaxContentWidth);
        defaultSettings.setWidth(this.defaultColumnWidth);
        defaultSettings.setValueFormatter(this.getDefaultValueFormatter(dataContainer, colIdx));
        defaultSettings.setHeaderFormatter(this.defaultHeaderFormatter);
        return defaultSettings;
    }

    private ValueFormatter getDefaultHeaderFormatter(DataContainer<?, ?> dataContainer, int colIdx) {
        return this.defaultHeaderFormatter;
    }

    private ValueFormatter getDefaultValueFormatter(DataContainer<?, ?> dataContainer, int colIdx) {
        Object header = dataContainer.getHeader();
        if (header instanceof BasicTypeHeader) {
            BasicTypeHeader typeHeader = (BasicTypeHeader)header;
            Class<Comparable> type = typeHeader.getType(colIdx);
            return this.getDefaultValueFormatter(type);
        }
        return null;
    }

    private ValueFormatter getDefaultValueFormatter(Object val) {
        if (val instanceof Number && this.defaultNumberFormatter != null) {
            return this.defaultNumberFormatter;
        }
        return this.defaultValueFormatter;
    }

    private ValueFormatter getDefaultValueFormatter(Class<?> type) {
        if (Number.class.isAssignableFrom(type) && this.defaultNumberFormatter != null) {
            return this.defaultNumberFormatter;
        }
        return this.defaultValueFormatter;
    }

    public String getTopLeftCorner() {
        return this.topLeftCorner;
    }

    public void setTopLeftCorner(String topLeftCorner) {
        this.topLeftCorner = topLeftCorner;
    }

    public String getTopRightCorner() {
        return this.topRightCorner;
    }

    public void setTopRightCorner(String topRightCorner) {
        this.topRightCorner = topRightCorner;
    }

    public String getBottomLeftCorner() {
        return this.bottomLeftCorner;
    }

    public void setBottomLeftCorner(String bottomLeftCorner) {
        this.bottomLeftCorner = bottomLeftCorner;
    }

    public String getBottomRightCorner() {
        return this.bottomRightCorner;
    }

    public void setBottomRightCorner(String bottomRightCorner) {
        this.bottomRightCorner = bottomRightCorner;
    }

    public String getTopLine() {
        return this.topLine;
    }

    public void setTopLine(String topLine) {
        this.topLine = topLine;
    }

    public String getBottomLine() {
        return this.bottomLine;
    }

    public void setBottomLine(String bottomLine) {
        this.bottomLine = bottomLine;
    }

    public String getLeftLine() {
        return this.leftLine;
    }

    public void setLeftLine(String leftLine) {
        this.leftLine = leftLine;
    }

    public String getRightLine() {
        return this.rightLine;
    }

    public void setRightLine(String rightLine) {
        this.rightLine = rightLine;
    }

    public String gettLeft() {
        return this.tLeft;
    }

    public void settLeft(String tLeft) {
        this.tLeft = tLeft;
    }

    public String gettRight() {
        return this.tRight;
    }

    public void settRight(String tRight) {
        this.tRight = tRight;
    }

    public String gettTop() {
        return this.tTop;
    }

    public void settTop(String tTop) {
        this.tTop = tTop;
    }

    public String gettBottom() {
        return this.tBottom;
    }

    public void settBottom(String tBottom) {
        this.tBottom = tBottom;
    }

    public String getInnerVerticalLine() {
        return this.innerVerticalLine;
    }

    public void setInnerVerticalLine(String innerVerticalLine) {
        this.innerVerticalLine = innerVerticalLine;
    }

    public String getInnerHorizontalLine() {
        return this.innerHorizontalLine;
    }

    public void setInnerHorizontalLine(String innerHorizontalLine) {
        this.innerHorizontalLine = innerHorizontalLine;
    }

    public String getInnerCrossConnection() {
        return this.innerCrossConnection;
    }

    public void setInnerCrossConnection(String innerCrossConnection) {
        this.innerCrossConnection = innerCrossConnection;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(int defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public int getDefaultMaxContentWidth() {
        return this.defaultMaxContentWidth;
    }

    public void setDefaultMaxContentWidth(int defaultMaxContentWidth) {
        this.defaultMaxContentWidth = defaultMaxContentWidth;
    }

    public ValueFormatter getDefaultValueFormatter() {
        return this.defaultValueFormatter;
    }

    public void setDefaultValueFormatter(ValueFormatter defaultValueFormatter) {
        this.defaultValueFormatter = defaultValueFormatter;
    }

    public ValueFormatter getDefaultHeaderFormatter() {
        return this.defaultHeaderFormatter;
    }

    public void setDefaultHeaderFormatter(ValueFormatter defaultHeaderFormatter) {
        this.defaultHeaderFormatter = defaultHeaderFormatter;
    }

    public ValueFormatter getDefaultNumberFormatter() {
        return this.defaultNumberFormatter;
    }

    public void setDefaultNumberFormatter(ValueFormatter defaultNumberFormatter) {
        this.defaultNumberFormatter = defaultNumberFormatter;
    }

    public Map<Object, ColumnPrintSettings> getColumnSettings() {
        return this.columnSettings;
    }

    @Override
    public Map<String, String> getSettings(DataFrame dataFrame) {
        return null;
    }

    @Override
    public List<DataFrameColumn> getMetaColumns(DataFrame dataFrame) {
        return null;
    }

    @Override
    public ReadFormat getReadFormat() {
        return null;
    }

    private class ColumnWidth {
        public int contentWidth;
        public int width;

        private ColumnWidth() {
        }
    }
}

