/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.print;

import de.unknownreality.dataframe.io.WriterBuilder;
import de.unknownreality.dataframe.print.ColumnPrintSettings;
import de.unknownreality.dataframe.print.DefaultNumberFormatter;
import de.unknownreality.dataframe.print.DefaultValueFormatter;
import de.unknownreality.dataframe.print.Printer;
import de.unknownreality.dataframe.print.ValueFormatter;
import java.util.HashMap;
import java.util.Map;

public final class PrinterBuilder
implements WriterBuilder<Printer> {
    private String topLeftCorner = "\u250c";
    private String topRightCorner = "\u2510";
    private String bottomLeftCorner = "\u2514";
    private String bottomRightCorner = "\u2518";
    private String topLine = "\u2500";
    private String bottomLine = "\u2500";
    private String leftLine = "\u2502";
    private String rightLine = "\u2502";
    private String innerVerticalLine = "\u2502";
    private String innerHorizontalLine = "\u2500";
    private String innerCrossConnection = "\u253c";
    private String tLeft = "\u2524";
    private String tRight = "\u251c";
    private String tTop = "\u2534";
    private String tBottom = "\u252c";
    private int defaultColumnWidth = 12;
    private int defaultMaxContentWidth = 10;
    private ValueFormatter defaultValueFormatter = new DefaultValueFormatter();
    private ValueFormatter defaultHeaderFormatter = (v, m) -> "#" + v.toString();
    private ValueFormatter defaultNumberFormatter = new DefaultNumberFormatter();
    private Map<Object, ColumnPrintSettings> columnSettings = new HashMap<Object, ColumnPrintSettings>();

    private PrinterBuilder() {
    }

    public static PrinterBuilder create() {
        return new PrinterBuilder();
    }

    public PrinterBuilder withColumnSetting(Object header, ColumnPrintSettings setting) {
        this.columnSettings.put(header, setting);
        return this;
    }

    public PrinterBuilder withColumnSetting(Object header, int width, int contentWidth, ValueFormatter headerFormatter, ValueFormatter valueFormatter) {
        ColumnPrintSettings settings = new ColumnPrintSettings(header);
        settings.setHeaderFormatter(headerFormatter);
        settings.setValueFormatter(valueFormatter);
        settings.setWidth(width);
        settings.setMaxContentWidth(contentWidth);
        this.columnSettings.put(header, settings);
        return this;
    }

    public PrinterBuilder withColumnSetting(Object header, int width, ValueFormatter valueFormatter) {
        return this.withColumnSetting(header, width, width - 2, null, null);
    }

    public PrinterBuilder withColumnWidth(Object header, int width) {
        ColumnPrintSettings settings = this.columnSettings.computeIfAbsent(header, h -> new ColumnPrintSettings(header));
        settings.setWidth(width);
        return this;
    }

    public PrinterBuilder withAutoWidth(Object header) {
        ColumnPrintSettings settings = this.columnSettings.computeIfAbsent(header, h -> new ColumnPrintSettings(header));
        settings.setAutoWidth(true);
        return this;
    }

    public PrinterBuilder withTTop(String tTop) {
        this.tTop = tTop;
        return this;
    }

    public PrinterBuilder withTBottom(String tBottom) {
        this.tBottom = tBottom;
        return this;
    }

    public PrinterBuilder withTLeft(String tLeft) {
        this.tLeft = tLeft;
        return this;
    }

    public PrinterBuilder withTRight(String tRight) {
        this.tRight = tRight;
        return this;
    }

    public PrinterBuilder withColumnContentWidth(Object header, int contentWidth) {
        ColumnPrintSettings settings = this.columnSettings.computeIfAbsent(header, h -> new ColumnPrintSettings(header));
        settings.setMaxContentWidth(contentWidth);
        return this;
    }

    public PrinterBuilder withColumnValueFormatter(Object header, ValueFormatter formatter) {
        ColumnPrintSettings settings = this.columnSettings.computeIfAbsent(header, h -> new ColumnPrintSettings(header));
        settings.setValueFormatter(formatter);
        return this;
    }

    public PrinterBuilder withColumnHeaderFormatter(Object header, ValueFormatter formatter) {
        ColumnPrintSettings settings = this.columnSettings.computeIfAbsent(header, h -> new ColumnPrintSettings(header));
        settings.setHeaderFormatter(formatter);
        return this;
    }

    public PrinterBuilder withTopLeftCorner(String topLeftCorner) {
        this.topLeftCorner = topLeftCorner;
        return this;
    }

    public PrinterBuilder withTopRightCorner(String topRightCorner) {
        this.topRightCorner = topRightCorner;
        return this;
    }

    public PrinterBuilder withBottomLeftCorner(String bottomLeftCorner) {
        this.bottomLeftCorner = bottomLeftCorner;
        return this;
    }

    public PrinterBuilder withBottomRightCorner(String bottomRightCorner) {
        this.bottomRightCorner = bottomRightCorner;
        return this;
    }

    public PrinterBuilder withCorner(String corner) {
        this.withBottomLeftCorner(corner);
        this.withBottomRightCorner(corner);
        this.withTopRightCorner(corner);
        this.withTopLeftCorner(corner);
        return this;
    }

    public PrinterBuilder withVerticalLine(String vline) {
        this.withLeftLine(vline);
        this.withRightLine(vline);
        this.withInnerVerticalLine(vline);
        return this;
    }

    public PrinterBuilder withHorizontalLine(String hline) {
        this.withTopLine(hline);
        this.withBottomLine(hline);
        this.withInnerHorizontalLine(hline);
        return this;
    }

    public PrinterBuilder withJoint(String joint) {
        this.withInnerCrossConnection(joint);
        this.withTLeft(joint);
        this.withTRight(joint);
        this.withTBottom(joint);
        this.withTTop(joint);
        return this;
    }

    public PrinterBuilder withTopLine(String topLine) {
        this.topLine = topLine;
        return this;
    }

    public PrinterBuilder withBottomLine(String bottomLine) {
        this.bottomLine = bottomLine;
        return this;
    }

    public PrinterBuilder withLeftLine(String leftLine) {
        this.leftLine = leftLine;
        return this;
    }

    public PrinterBuilder withRightLine(String rightLine) {
        this.rightLine = rightLine;
        return this;
    }

    public PrinterBuilder withInnerVerticalLine(String innerVerticalLine) {
        this.innerVerticalLine = innerVerticalLine;
        return this;
    }

    public PrinterBuilder withInnerHorizontalLine(String innerHorizontalLine) {
        this.innerHorizontalLine = innerHorizontalLine;
        return this;
    }

    public PrinterBuilder withInnerCrossConnection(String innerCrossConnection) {
        this.innerCrossConnection = innerCrossConnection;
        return this;
    }

    public PrinterBuilder withDefaultColumnWidth(int defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
        return this;
    }

    public PrinterBuilder withDefaultMaxContentWidth(int defaultMaxContentWidth) {
        this.defaultMaxContentWidth = defaultMaxContentWidth;
        return this;
    }

    public PrinterBuilder withDefaultValueFormatter(ValueFormatter defaultValueFormatter) {
        this.defaultValueFormatter = defaultValueFormatter;
        return this;
    }

    public PrinterBuilder withDefaultHeaderFormatter(ValueFormatter defaultHeaderFormatter) {
        this.defaultHeaderFormatter = defaultHeaderFormatter;
        return this;
    }

    public PrinterBuilder withDefaultNumberFormatter(ValueFormatter defaultNumberFormatter) {
        this.defaultNumberFormatter = defaultNumberFormatter;
        return this;
    }

    @Override
    public Printer build() {
        Printer printer = new Printer();
        printer.setTopLeftCorner(this.topLeftCorner);
        printer.setTopRightCorner(this.topRightCorner);
        printer.setBottomLeftCorner(this.bottomLeftCorner);
        printer.setBottomRightCorner(this.bottomRightCorner);
        printer.setTopLine(this.topLine);
        printer.setBottomLine(this.bottomLine);
        printer.setLeftLine(this.leftLine);
        printer.setRightLine(this.rightLine);
        printer.settTop(this.tTop);
        printer.settRight(this.tRight);
        printer.settLeft(this.tLeft);
        printer.settBottom(this.tBottom);
        printer.setInnerVerticalLine(this.innerVerticalLine);
        printer.setInnerHorizontalLine(this.innerHorizontalLine);
        printer.setInnerCrossConnection(this.innerCrossConnection);
        printer.setDefaultColumnWidth(this.defaultColumnWidth);
        printer.setDefaultMaxContentWidth(this.defaultMaxContentWidth);
        printer.setDefaultValueFormatter(this.defaultValueFormatter);
        printer.setDefaultHeaderFormatter(this.defaultHeaderFormatter);
        printer.setDefaultNumberFormatter(this.defaultNumberFormatter);
        printer.getColumnSettings().putAll(this.columnSettings);
        return printer;
    }
}

