/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.transform;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.column.StringColumn;
import de.unknownreality.dataframe.common.parser.Parser;

public class StringColumnConverter {
    public static <V extends Comparable<V>, C extends DataFrameColumn<V, C>> C convert(StringColumn column, Class<C> colType) throws DataFrameException {
        DataFrameColumn newColumn;
        if (colType == StringColumn.class) {
            return (C)column.copy();
        }
        try {
            newColumn = (DataFrameColumn)colType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DataFrameException("error creating column instance", e);
        }
        newColumn.setName(column.getName());
        Parser parser = newColumn.getParser();
        if (parser == null) {
            throw new DataFrameException(String.format("no parser defined for column type '%s'", colType.getCanonicalName()));
        }
        for (int i = 0; i < column.size(); ++i) {
            if (column.isNA(i)) {
                newColumn.appendNA();
                continue;
            }
            Comparable value = (Comparable)newColumn.getParser().parseOrNull((String)column.get(i));
            if (value == null) {
                throw new DataFrameException(String.format("error parsing value '%s' -> ", column.get(i), newColumn.getType()));
            }
            newColumn.append(value);
        }
        return (C)newColumn;
    }
}

