/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.html2txt;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.xml.XmlUtil;
import de.unkrig.commons.util.collections.MapUtil;
import de.unkrig.html2txt.TableFormatter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Html2Txt {
    public static final ErrorHandler SIMPLE_SAX_ERROR_HANDLER;
    public static final HtmlErrorHandler SIMPLE_HTML_ERROR_HANDLER;
    private static final Pattern RELEVANT_HREF_PATTERN;
    HtmlErrorHandler htmlErrorHandler = SIMPLE_HTML_ERROR_HANDLER;
    private int pageLeftMarginWidth;
    private int pageRightMarginWidth = 1;
    private Charset inputCharset = Charset.defaultCharset();
    private Charset outputCharset = Charset.defaultCharset();
    private int pageWidth;
    private static final BlockElementFormatter HR_FORMATTER;
    protected static final BlockElementFormatter OL_FORMATTER;
    private static final BlockElementFormatter LI_FORMATTER;
    private static final BlockElementFormatter PRE_FORMATTER;
    protected static final BlockElementFormatter TABLE_FORMATTER;
    private static final BlockElementFormatter UL_FORMATTER;
    private static final BlockElementFormatter IGNORE_BLOCK_ELEMENT_FORMATTER;
    private static final BlockElementFormatter NOP_BLOCK_ELEMENT_FORMATTER;
    private static final BlockElementFormatter NYI_BLOCK_ELEMENT_FORMATTER;
    protected static final Map<String, BlockElementFormatter> ALL_BLOCK_ELEMENTS;
    private static final InlineElementFormatter A_FORMATTER;
    private static final InlineElementFormatter ABBR_FORMATTER;
    private static final InlineElementFormatter BR_FORMATTER;
    private static final InlineElementFormatter IMG_FORMATTER;
    private static final InlineElementFormatter INPUT_FORMATTER;
    private static final InlineElementFormatter Q_FORMATTER;
    private static final InlineElementFormatter IGNORE_INLINE_ELEMENT_FORMATTER;
    private static final InlineElementFormatter NYI_INLINE_ELEMENT_FORMATTER;
    protected static final Map<String, InlineElementFormatter> ALL_INLINE_ELEMENTS;

    public Html2Txt() {
        try {
            this.pageWidth = Integer.parseInt(System.getenv("COLUMNS"));
        }
        catch (Exception e) {
            this.pageWidth = 80;
        }
    }

    public Html2Txt setErrorHandler(HtmlErrorHandler htmlErrorHandler) {
        this.htmlErrorHandler = htmlErrorHandler;
        return this;
    }

    public Html2Txt setPageLeftMarginWidth(int pageLeftMarginWidth) {
        this.pageLeftMarginWidth = pageLeftMarginWidth;
        return this;
    }

    public Html2Txt setPageRightMarginWidth(int pageRightMarginWidth) {
        this.pageRightMarginWidth = pageRightMarginWidth;
        return this;
    }

    public void setInputCharset(Charset cs) {
        this.inputCharset = cs;
    }

    public void setOutputCharset(Charset cs) {
        this.outputCharset = cs;
    }

    public Html2Txt setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
        return this;
    }

    public void html2txt(File inputFile, Writer output) throws ParserConfigurationException, SAXException, TransformerException, HtmlException, IOException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        db.setErrorHandler(SIMPLE_SAX_ERROR_HANDLER);
        Document document = XmlUtil.parse((DocumentBuilder)db, (File)inputFile, (String)this.inputCharset.name());
        this.html2txt(document, output);
    }

    public void html2txt(Reader input, Writer output) throws ParserConfigurationException, SAXException, TransformerException, HtmlException, IOException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        db.setErrorHandler(SIMPLE_SAX_ERROR_HANDLER);
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(input);
        Document document = XmlUtil.parse((DocumentBuilder)db, (InputSource)inputSource);
        this.html2txt(document, output);
    }

    public void html2txt(Document document, Writer output) throws HtmlException {
        document.getDocumentElement().normalize();
        PrintWriter pw = output instanceof PrintWriter ? (PrintWriter)output : new PrintWriter(output);
        this.html2txt(document, (Consumer<? super CharSequence>)LineUtil.lineConsumer((PrintWriter)pw));
    }

    public void html2txt(final File inputFile, File outputFile) throws Exception {
        IoUtil.outputFilePrintWriter((File)outputFile, (Charset)this.outputCharset, (ConsumerWhichThrows)new ConsumerWhichThrows<PrintWriter, Exception>(){

            public void consume(PrintWriter pw) throws Exception {
                Html2Txt.this.html2txt(inputFile, (Writer)pw);
            }
        });
    }

    private void html2txt(Document document, Consumer<? super CharSequence> output) throws HtmlException {
        output = ConsumerUtil.compress(output, (Predicate)StringUtil.IS_BLANK, (Object)"");
        output = Html2Txt.rightTrim((Consumer<? super String>)output);
        Element documentElement = document.getDocumentElement();
        if ("html".equalsIgnoreCase(documentElement.getNodeName())) {
            for (Node n : XmlUtil.iterable((NodeList)documentElement.getChildNodes())) {
                if (n.getNodeType() != 1 || !"body".equalsIgnoreCase(n.getNodeName())) continue;
                Element bodyElement = (Element)n;
                this.formatBlocks(this.pageLeftMarginWidth, Bulleting.NONE, Bulleting.NONE, this.pageWidth - this.pageLeftMarginWidth - this.pageRightMarginWidth, Alignment.LEFT, XmlUtil.iterable((NodeList)bodyElement.getChildNodes()), output);
            }
            return;
        }
        this.formatBlocks(this.pageLeftMarginWidth, Bulleting.NONE, Bulleting.NONE, this.pageWidth - this.pageLeftMarginWidth - this.pageRightMarginWidth, Alignment.LEFT, Collections.singletonList(documentElement), output);
    }

    <N extends Node> void formatBlocks(int leftMarginWidth, Bulleting inlineSubelementsBulleting, Bulleting blockSubelementsBulleting, int measure, Alignment alignment, Iterable<N> nodes, Consumer<? super CharSequence> output) throws HtmlException {
        ArrayList<Node> inlineNodes = new ArrayList<Node>();
        for (Node n : nodes) {
            if (n.getNodeType() == 3) {
                inlineNodes.add(n);
                continue;
            }
            if (Html2Txt.isInlineElement(n)) {
                inlineNodes.add(n);
                continue;
            }
            if (Html2Txt.isBlockElement(n)) {
                Element e;
                BlockElementFormatter bef;
                if (!inlineNodes.isEmpty()) {
                    this.wordWrap(leftMarginWidth, inlineSubelementsBulleting, measure, alignment, this.getBlock(inlineNodes), output);
                    inlineNodes.clear();
                }
                if ((bef = ALL_BLOCK_ELEMENTS.get((e = (Element)n).getTagName())) == null) {
                    this.htmlErrorHandler.error(new HtmlException(n, "Unexpected block element \"" + XmlUtil.toString((Node)e) + "\" in block"));
                    continue;
                }
                bef.format(this, leftMarginWidth, blockSubelementsBulleting, measure, alignment, e, output);
                continue;
            }
            this.htmlErrorHandler.error(new HtmlException(n, "Unexpected node \"" + XmlUtil.toString((Node)n) + "\" in <body>"));
        }
        if (!inlineNodes.isEmpty()) {
            this.wordWrap(leftMarginWidth, inlineSubelementsBulleting, measure, alignment, this.getBlock(inlineNodes), output);
            inlineNodes.clear();
        }
    }

    private void wordWrap(int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, String text, Consumer<? super CharSequence> output) throws HtmlException {
        switch (alignment) {
            case LEFT: {
                this.wordWrapLeftAligned(leftMarginWidth, bulleting, measure, text, (ConsumerWhichThrows)output);
                return;
            }
            case RIGHT: {
                this.wordWrapLeftAligned(leftMarginWidth, bulleting, measure, text, Html2Txt.consumer(Html2Txt.alignRight(leftMarginWidth, measure), output));
                break;
            }
            case CENTER: {
                this.wordWrapLeftAligned(leftMarginWidth, bulleting, measure, text, Html2Txt.consumer(Html2Txt.center(leftMarginWidth, measure), output));
                break;
            }
            case JUSTIFY: {
                ArrayList tmp = new ArrayList();
                this.wordWrapLeftAligned(leftMarginWidth, bulleting, measure, text, (ConsumerWhichThrows)ConsumerUtil.addToCollection(tmp));
                ConsumerUtil.tail(tmp, (int)1, Html2Txt.consumer(Html2Txt.justify(leftMarginWidth, measure), output), output);
                break;
            }
            default: {
                throw new AssertionError((Object)alignment);
            }
        }
    }

    private static Transformer<CharSequence, CharSequence> alignRight(final int leftMarginWidth, final int measure) {
        return new Transformer<CharSequence, CharSequence>(){

            public CharSequence transform(CharSequence in) {
                int delta = leftMarginWidth + measure - in.length();
                if (delta <= 0) {
                    return in;
                }
                return in.subSequence(0, leftMarginWidth) + StringUtil.repeat((int)delta, (char)' ') + in.subSequence(leftMarginWidth, in.length());
            }
        };
    }

    private static Transformer<CharSequence, CharSequence> center(final int leftMarginWidth, final int measure) {
        return new Transformer<CharSequence, CharSequence>(){

            public CharSequence transform(CharSequence in) {
                int delta = leftMarginWidth + measure - in.length();
                if (delta <= 0) {
                    return in;
                }
                return in.subSequence(0, leftMarginWidth) + StringUtil.repeat((int)(delta / 2), (char)' ') + in.subSequence(leftMarginWidth, in.length());
            }
        };
    }

    private static Transformer<CharSequence, CharSequence> justify(final int leftMarginWidth, final int measure) {
        return new Transformer<CharSequence, CharSequence>(){

            public CharSequence transform(CharSequence in) {
                int delta = leftMarginWidth + measure - in.length();
                if (delta <= 0) {
                    return in;
                }
                int spaces = 0;
                for (int j = leftMarginWidth; j < in.length(); ++j) {
                    if (in.charAt(j) != ' ') continue;
                    ++spaces;
                }
                if (spaces == 0) {
                    return in;
                }
                StringBuilder sb = new StringBuilder(in.subSequence(0, leftMarginWidth));
                int x = 0;
                for (int j = leftMarginWidth; j < in.length(); ++j) {
                    char c = in.charAt(j);
                    sb.append(c);
                    if (c != ' ') continue;
                    while (x < delta) {
                        sb.append(' ');
                        x += spaces;
                    }
                    x -= delta;
                }
                return sb.toString();
            }
        };
    }

    private static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> consumer(final TransformerWhichThrows<? super T, ? extends T, ? extends EX> transformer, final ConsumerWhichThrows<? super T, ? extends EX> delegate) {
        return new ConsumerWhichThrows<T, EX>(){

            public void consume(T subject) throws Throwable {
                delegate.consume(transformer.transform(subject));
            }
        };
    }

    private <EX extends Throwable> void wordWrapLeftAligned(int leftMarginWidth, Bulleting bulleting, int measure, String text, ConsumerWhichThrows<? super CharSequence, ? extends EX> output) throws HtmlException, EX {
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (measure < 1) {
            measure = 1;
        }
        int nlidx = text.indexOf(10);
        while (nlidx != -1) {
            this.wordWrapLeftAligned(leftMarginWidth, bulleting, measure, text.substring(0, nlidx), output);
            ++nlidx;
            while (nlidx < text.length() && text.charAt(nlidx) == ' ') {
                ++nlidx;
            }
            if (nlidx == text.length()) {
                return;
            }
            text = text.substring(nlidx);
            nlidx = text.indexOf(10);
        }
        String continuationLineLeftMargin = StringUtil.repeat((int)leftMarginWidth, (char)' ');
        String bullet = bulleting.next();
        String leftMargin = bullet.length() == 0 ? continuationLineLeftMargin : (bullet.length() + 1 < leftMarginWidth ? StringUtil.repeat((int)(leftMarginWidth - bullet.length() - 1), (char)' ') + bullet + ' ' : bullet + ' ');
        while (text.length() > measure) {
            int idx2;
            int idx1;
            block17: {
                if (text.charAt(measure) == ' ') {
                    for (idx1 = measure; idx1 > 0 && text.charAt(idx1 - 1) == ' '; --idx1) {
                    }
                    for (idx2 = measure + 1; idx2 < text.length() && text.charAt(idx2) == ' '; ++idx2) {
                    }
                } else {
                    for (idx2 = measure; idx2 > 0 && text.charAt(idx2 - 1) != ' '; --idx2) {
                        if (text.charAt(idx2 - 1) != '-' || text.charAt(idx2) == '-' || idx2 < 2 || text.charAt(idx2 - 2) == '-') continue;
                        idx1 = idx2;
                        break block17;
                    }
                    if (idx2 == 0) {
                        for (idx1 = measure + 1; idx1 < text.length() && text.charAt(idx1) != ' '; ++idx1) {
                        }
                        if (idx1 == text.length()) break;
                        for (idx2 = idx1 + 1; idx2 < text.length() && text.charAt(idx2) == ' '; ++idx2) {
                        }
                        if (idx2 == text.length()) {
                            text = text.substring(0, idx1);
                            break;
                        }
                    } else {
                        idx1 = idx2 - 1;
                        while (text.charAt(idx1 - 1) == ' ') {
                            --idx1;
                        }
                    }
                }
            }
            output.consume((Object)(leftMargin + text.substring(0, idx1)));
            text = text.substring(idx2);
            leftMargin = continuationLineLeftMargin;
        }
        output.consume((Object)(leftMargin + text));
    }

    private String getBlock(Iterable<Node> nodes) throws HtmlException {
        StringBuilder sb = new StringBuilder();
        for (Node n : nodes) {
            short nodeType = n.getNodeType();
            if (nodeType == 3) {
                String content = n.getTextContent();
                sb.append(content.replaceAll("\\s+", " "));
                continue;
            }
            if (nodeType == 1) {
                Element e = (Element)n;
                InlineElementFormatter ief = ALL_INLINE_ELEMENTS.get(e.getTagName());
                if (ief == null) {
                    this.htmlErrorHandler.error(new HtmlException(n, "Unexpected element \"" + XmlUtil.toString((Node)e) + "\" in block"));
                    continue;
                }
                ief.format(this, e, sb);
                continue;
            }
            this.htmlErrorHandler.error(new HtmlException(n, "Unexpected node in block"));
        }
        return sb.toString();
    }

    private static boolean isBlockElement(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element e = (Element)node;
        return ALL_BLOCK_ELEMENTS.containsKey(e.getTagName());
    }

    @Nullable
    static Element isElement(Node node, String tagName) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element e = (Element)node;
        return tagName.equalsIgnoreCase(e.getTagName()) ? e : null;
    }

    public static int maxLength(Iterable<? extends CharSequence> css) {
        int result = 0;
        for (CharSequence charSequence : css) {
            int len = charSequence.length();
            if (len <= result) continue;
            result = len;
        }
        return result;
    }

    @Nullable
    private static String getAttribute(Element element, String attributeName) {
        String s = element.getAttribute(attributeName);
        return s.isEmpty() ? null : s;
    }

    private static <T> T getAttribute(Element element, String attributeName, T defaulT) {
        T result = Html2Txt.getAttribute(element, attributeName, defaulT.getClass());
        return result != null ? result : defaulT;
    }

    @Nullable
    private static <T> T getAttribute(Element element, String attributeName, Class<?> type) {
        String s = element.getAttribute(attributeName);
        if (s.isEmpty()) {
            return null;
        }
        if (type == String.class) {
            String result = s;
            return (T)result;
        }
        if (Enum.class.isAssignableFrom(type)) {
            try {
                Object result = Enum.valueOf(type, s.toUpperCase());
                return (T)result;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        try {
            Object result = type.getClass().getConstructor(String.class).newInstance(s);
            return (T)result;
        }
        catch (InvocationTargetException ite) {
            return null;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean attributeEquals(Element element, String attributeName, String expected) {
        return expected.equalsIgnoreCase(element.getAttribute(attributeName));
    }

    private static boolean isInlineElement(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element e = (Element)node;
        return ALL_INLINE_ELEMENTS.containsKey(e.getTagName());
    }

    public static Producer<? extends String> rightPad(final Producer<? extends CharSequence> delegate, final int width, final char c) {
        return new Producer<String>(){

            @Nullable
            public String produce() {
                CharSequence cs = (CharSequence)delegate.produce();
                if (cs == null) {
                    return null;
                }
                return cs.length() < width ? cs + StringUtil.repeat((int)(width - cs.length()), (char)c) : cs.toString();
            }
        };
    }

    public static Consumer<CharSequence> rightTrim(final Consumer<? super String> delegate) {
        return new Consumer<CharSequence>(){

            public void consume(CharSequence subject) {
                int len = subject.length();
                if (len == 0 || subject.charAt(len - 1) != ' ') {
                    delegate.consume((Object)subject.toString());
                } else {
                    len -= 2;
                    while (len >= 0 && subject.charAt(len) == ' ') {
                        --len;
                    }
                    delegate.consume((Object)subject.toString().substring(0, len + 1));
                }
            }
        };
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        SIMPLE_SAX_ERROR_HANDLER = new ErrorHandler(){

            @Override
            public void warning(@Nullable SAXParseException e) throws SAXParseException {
                throw e;
            }

            @Override
            public void fatalError(@Nullable SAXParseException e) throws SAXParseException {
                throw e;
            }

            @Override
            public void error(@Nullable SAXParseException e) throws SAXParseException {
                throw e;
            }
        };
        SIMPLE_HTML_ERROR_HANDLER = new HtmlErrorHandler(){

            @Override
            public void warning(HtmlException e) throws HtmlException {
                throw e;
            }

            @Override
            public void fatalError(HtmlException e) throws HtmlException {
                throw e;
            }

            @Override
            public void error(HtmlException e) throws HtmlException {
                throw e;
            }
        };
        RELEVANT_HREF_PATTERN = Pattern.compile("\\w+:.*");
        HR_FORMATTER = new BlockElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) {
                output.consume((Object)(StringUtil.repeat((int)leftMarginWidth, (char)' ') + StringUtil.repeat((int)measure, (char)'-')));
            }
        };
        OL_FORMATTER = new BlockElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, final Element element, Consumer<? super CharSequence> output) throws HtmlException {
                String s = Html2Txt.getAttribute(element, "type");
                final NumberingType numberingType = "a".equals(s) ? NumberingType.LOWERCASE_LETTERS : ("A".equals(s) ? NumberingType.UPPERCASE_LETTERS : ("i".equals(s) ? NumberingType.LOWERCASE_ROMAN_NUMERALS : ("I".equals(s) ? NumberingType.UPPERCASE_ROMAN_LITERALS : NumberingType.ARABIC_DIGITS)));
                html2Txt.formatBlocks(leftMarginWidth + 5, Bulleting.NONE, new Bulleting(){
                    int nextValue;
                    {
                        this.nextValue = (Integer)Html2Txt.getAttribute(element, "start", 1);
                    }

                    @Override
                    public String next() {
                        return numberingType.toString(this.nextValue++) + ".";
                    }
                }, measure - 5, alignment, XmlUtil.iterable((NodeList)element.getChildNodes()), output);
            }
        };
        LI_FORMATTER = new BlockElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) throws HtmlException {
                html2Txt.formatBlocks(leftMarginWidth, bulleting, Bulleting.NONE, measure, alignment, XmlUtil.iterable((NodeList)element.getChildNodes()), output);
            }
        };
        PRE_FORMATTER = new BlockElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) throws HtmlException {
                CharSequence line;
                StringBuilder sb = new StringBuilder();
                for (Node n : XmlUtil.iterable((NodeList)element.getChildNodes())) {
                    short nodeType = n.getNodeType();
                    if (nodeType == 3) {
                        sb.append(n.getTextContent());
                        continue;
                    }
                    if (nodeType == 1) {
                        Element e = (Element)n;
                        InlineElementFormatter ief = ALL_INLINE_ELEMENTS.get(e.getTagName());
                        if (ief == null) {
                            html2Txt.htmlErrorHandler.error(new HtmlException(n, "Unexpected element \"" + XmlUtil.toString((Node)e) + "\" in <pre>"));
                            continue;
                        }
                        ief.format(html2Txt, e, sb);
                        continue;
                    }
                    html2Txt.htmlErrorHandler.error(new HtmlException(n, "Unexpected node in <pre>"));
                }
                Producer lp = LineUtil.lineProducer((CharSequence)sb);
                boolean first = true;
                while ((line = (CharSequence)lp.produce()) != null) {
                    if (!first || line.length() != 0) {
                        if (first) {
                            String bullet = bulleting.next();
                            line = bullet.length() + 1 > leftMarginWidth ? bullet + ' ' + line : StringUtil.repeat((int)(leftMarginWidth - bullet.length() - 1), (char)' ') + bullet + ' ' + line;
                        }
                        output.consume((Object)line);
                    }
                    first = false;
                }
            }
        };
        TABLE_FORMATTER = new TableFormatter();
        UL_FORMATTER = new BlockElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) throws HtmlException {
                html2Txt.formatBlocks(leftMarginWidth + 3, Bulleting.NONE, new Bulleting(){

                    @Override
                    public String next() {
                        return "*";
                    }
                }, measure - 3, alignment, XmlUtil.iterable((NodeList)element.getChildNodes()), output);
            }
        };
        IGNORE_BLOCK_ELEMENT_FORMATTER = new IndentingBlockElementFormatter(0);
        NOP_BLOCK_ELEMENT_FORMATTER = new BlockElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) {
            }
        };
        NYI_BLOCK_ELEMENT_FORMATTER = new BlockElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) throws HtmlException {
                html2Txt.htmlErrorHandler.warning(new HtmlException(element, "HTML block element \"<" + element.getNodeName() + ">\" is not yet implemented and thus ignored"));
                IGNORE_BLOCK_ELEMENT_FORMATTER.format(html2Txt, leftMarginWidth, bulleting, measure, alignment, element, output);
            }
        };
        ALL_BLOCK_ELEMENTS = Collections.unmodifiableMap(MapUtil.map((Object[])new Object[]{"address", new IndentingBlockElementFormatter(2), "article", IGNORE_BLOCK_ELEMENT_FORMATTER, "aside", IGNORE_BLOCK_ELEMENT_FORMATTER, "audio", NYI_BLOCK_ELEMENT_FORMATTER, "blockquote", new IndentingBlockElementFormatter(2), "canvas", IGNORE_BLOCK_ELEMENT_FORMATTER, "dd", new IndentingBlockElementFormatter(4), "div", IGNORE_BLOCK_ELEMENT_FORMATTER, "dl", new IndentingBlockElementFormatter(2), "dt", IGNORE_BLOCK_ELEMENT_FORMATTER, "fieldset", IGNORE_BLOCK_ELEMENT_FORMATTER, "figcaption", IGNORE_BLOCK_ELEMENT_FORMATTER, "figure", IGNORE_BLOCK_ELEMENT_FORMATTER, "footer", IGNORE_BLOCK_ELEMENT_FORMATTER, "form", IGNORE_BLOCK_ELEMENT_FORMATTER, "h1", new HeadingBlockElementFormatter(true, '*', true), "h2", new HeadingBlockElementFormatter(true, '=', true), "h3", new HeadingBlockElementFormatter(true, '-', true), "h4", new HeadingBlockElementFormatter("=== ", " ==="), "h5", new HeadingBlockElementFormatter("== ", " =="), "h6", new HeadingBlockElementFormatter("= ", " ="), "header", IGNORE_BLOCK_ELEMENT_FORMATTER, "hgroup", IGNORE_BLOCK_ELEMENT_FORMATTER, "hr", HR_FORMATTER, "li", LI_FORMATTER, "main", IGNORE_BLOCK_ELEMENT_FORMATTER, "nav", IGNORE_BLOCK_ELEMENT_FORMATTER, "noscript", NOP_BLOCK_ELEMENT_FORMATTER, "ol", OL_FORMATTER, "output", IGNORE_BLOCK_ELEMENT_FORMATTER, "p", IGNORE_BLOCK_ELEMENT_FORMATTER, "pre", PRE_FORMATTER, "section", IGNORE_BLOCK_ELEMENT_FORMATTER, "table", TABLE_FORMATTER, "tfoot", IGNORE_BLOCK_ELEMENT_FORMATTER, "ul", UL_FORMATTER, "video", NYI_BLOCK_ELEMENT_FORMATTER}));
        A_FORMATTER = new InlineElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, Element element, StringBuilder output) throws HtmlException {
                String name = Html2Txt.getAttribute(element, "name");
                String href = Html2Txt.getAttribute(element, "href");
                if (name != null && href == null) {
                    if (!html2Txt.getBlock(XmlUtil.iterable((NodeList)element.getChildNodes())).isEmpty()) {
                        html2Txt.htmlErrorHandler.warning(new HtmlException(element, "'<a name=\"...\" />' tag should not have content"));
                    }
                } else if (href != null && name == null) {
                    output.append(html2Txt.getBlock(XmlUtil.iterable((NodeList)element.getChildNodes())));
                    if (RELEVANT_HREF_PATTERN.matcher(href).matches()) {
                        output.append(" (see \"").append(href).append("\")");
                    }
                } else {
                    html2Txt.htmlErrorHandler.warning(new HtmlException(element, "\"<a>\" tag has an unexpected combination of attributes"));
                }
            }
        };
        ABBR_FORMATTER = new InlineElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, Element element, StringBuilder output) throws HtmlException {
                output.append(html2Txt.getBlock(XmlUtil.iterable((NodeList)element.getChildNodes())));
                String title = Html2Txt.getAttribute(element, "title");
                if (title != null) {
                    output.append(" (\"").append(title).append("\")");
                }
            }
        };
        BR_FORMATTER = new InlineElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, Element element, StringBuilder output) throws HtmlException {
                if (element.hasChildNodes()) {
                    html2Txt.htmlErrorHandler.warning(new HtmlException(element, "\"<br>\" tag should not have subelements nor contain text"));
                }
                output.append('\n');
            }
        };
        IMG_FORMATTER = new InlineElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, Element element, StringBuilder output) {
                output.append("[IMG]");
            }
        };
        INPUT_FORMATTER = new InlineElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, Element element, StringBuilder output) {
                String type = Html2Txt.getAttribute(element, "type");
                if ("checkbox".equalsIgnoreCase(type)) {
                    output.append(Html2Txt.attributeEquals(element, "checked", "checked") ? "[x]" : "[ ]");
                } else if (!"hidden".equalsIgnoreCase(type)) {
                    if ("password".equalsIgnoreCase(type)) {
                        output.append("[******]");
                    } else if ("radio".equalsIgnoreCase(type)) {
                        output.append(Html2Txt.attributeEquals(element, "checked", "checked") ? "(o)" : "( )");
                    } else if ("submit".equalsIgnoreCase(type)) {
                        output.append("[ ").append((String)Html2Txt.getAttribute(element, "value", "Submit")).append(" ]");
                    } else if ("text".equalsIgnoreCase(type) || type == null) {
                        output.append('[').append(element.getAttribute("value")).append(']');
                    } else {
                        output.append('[').append(type.toUpperCase()).append("-INPUT]");
                    }
                }
            }
        };
        Q_FORMATTER = new InlineElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, Element element, StringBuilder output) throws HtmlException {
                output.append('\"');
                output.append(html2Txt.getBlock(XmlUtil.iterable((NodeList)element.getChildNodes())));
                output.append("\"");
                String cite = Html2Txt.getAttribute(element, "cite");
                if (cite != null) {
                    output.append(" (").append(cite).append(')');
                }
            }
        };
        IGNORE_INLINE_ELEMENT_FORMATTER = new SimpleInlineElementFormatter("", "");
        NYI_INLINE_ELEMENT_FORMATTER = new InlineElementFormatter(){

            @Override
            public void format(Html2Txt html2Txt, Element element, StringBuilder output) throws HtmlException {
                html2Txt.htmlErrorHandler.warning(new HtmlException(element, "HTML inline element \"<" + element.getNodeName() + ">\" is not yet implemented and thus ignored"));
                output.append(html2Txt.getBlock(XmlUtil.iterable((NodeList)element.getChildNodes())));
            }
        };
        ALL_INLINE_ELEMENTS = MapUtil.map((Object[])new Object[]{"a", A_FORMATTER, "abbr", ABBR_FORMATTER, "acronym", ABBR_FORMATTER, "b", new SimpleInlineElementFormatter("*", "*"), "bdo", NYI_INLINE_ELEMENT_FORMATTER, "big", IGNORE_INLINE_ELEMENT_FORMATTER, "br", BR_FORMATTER, "button", new SimpleInlineElementFormatter("[ ", " ]"), "cite", IGNORE_INLINE_ELEMENT_FORMATTER, "code", IGNORE_INLINE_ELEMENT_FORMATTER, "dfn", IGNORE_INLINE_ELEMENT_FORMATTER, "em", new SimpleInlineElementFormatter("<", ">"), "i", new SimpleInlineElementFormatter("<", ">"), "img", IMG_FORMATTER, "input", INPUT_FORMATTER, "kbd", new SimpleInlineElementFormatter("[ ", " ]"), "label", IGNORE_INLINE_ELEMENT_FORMATTER, "map", NYI_INLINE_ELEMENT_FORMATTER, "object", NYI_INLINE_ELEMENT_FORMATTER, "q", Q_FORMATTER, "samp", IGNORE_INLINE_ELEMENT_FORMATTER, "script", NYI_INLINE_ELEMENT_FORMATTER, "select", new SimpleInlineElementFormatter("[ ", " ]"), "small", IGNORE_INLINE_ELEMENT_FORMATTER, "span", IGNORE_INLINE_ELEMENT_FORMATTER, "strong", new SimpleInlineElementFormatter("*", "*"), "sub", IGNORE_INLINE_ELEMENT_FORMATTER, "sup", new SimpleInlineElementFormatter("^", ""), "textarea", new SimpleInlineElementFormatter("[ ", " ]"), "tt", IGNORE_INLINE_ELEMENT_FORMATTER, "u", new SimpleInlineElementFormatter("_", "_"), "var", new SimpleInlineElementFormatter("<", ">")});
    }

    static class SimpleInlineElementFormatter
    implements InlineElementFormatter {
        private final String prefix;
        private final String suffix;

        SimpleInlineElementFormatter(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public void format(Html2Txt html2Txt, Element element, StringBuilder output) throws HtmlException {
            output.append(this.prefix);
            output.append(html2Txt.getBlock(XmlUtil.iterable((NodeList)element.getChildNodes())));
            output.append(this.suffix);
        }
    }

    public static class IndentingBlockElementFormatter
    implements BlockElementFormatter {
        private final int indentation;

        public IndentingBlockElementFormatter(int indentation) {
            this.indentation = indentation;
        }

        @Override
        public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) throws HtmlException {
            html2Txt.formatBlocks(leftMarginWidth + this.indentation, Bulleting.NONE, Bulleting.NONE, measure - this.indentation, (Alignment)((Object)Html2Txt.getAttribute(element, "align", (Object)alignment)), XmlUtil.iterable((NodeList)element.getChildNodes()), output);
        }
    }

    private static class HeadingBlockElementFormatter
    implements BlockElementFormatter {
        private boolean emptyLineAbove;
        private boolean emptyLineBelow;
        @Nullable
        private String prefix;
        @Nullable
        private String suffix;
        private int underline = -1;

        HeadingBlockElementFormatter(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        HeadingBlockElementFormatter(boolean emptyLineAbove, char underline, boolean emptyLineBelow) {
            this.emptyLineAbove = emptyLineAbove;
            this.underline = underline;
            this.emptyLineBelow = emptyLineBelow;
        }

        @Override
        public void format(Html2Txt html2Txt, int leftMarginWidth, Bulleting bulleting, int measure, Alignment alignment, Element element, Consumer<? super CharSequence> output) throws HtmlException {
            String text = html2Txt.getBlock(XmlUtil.iterable((NodeList)element.getChildNodes()));
            if (this.prefix != null) {
                text = this.prefix.concat(text);
            }
            if (this.suffix != null) {
                text = text.concat(this.suffix);
            }
            if (this.emptyLineAbove) {
                output.consume((Object)"");
            }
            output.consume((Object)text);
            if (this.underline != -1) {
                output.consume((Object)StringUtil.repeat((int)text.length(), (char)((char)this.underline)));
            }
            if (this.emptyLineBelow) {
                output.consume((Object)"");
            }
        }
    }

    static enum NumberingType {
        LOWERCASE_LETTERS{

            @Override
            public long parse(String s) {
                long result = 0L;
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        result = 26L * result + (long)(c - 65) + 1L;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        result = 26L * result + (long)(c - 97) + 1L;
                        continue;
                    }
                    throw new NumberFormatException();
                }
                return result;
            }

            @Override
            public String toString(long value) {
                if (value < 0L) {
                    return '-' + this.toString(-value);
                }
                if (value == 0L) {
                    throw new NumberFormatException();
                }
                if (value <= 26L) {
                    return String.valueOf((char)(value + 97L - 1L));
                }
                return this.toString(value / 26L) + (char)(value % 26L + 97L - 1L);
            }
        }
        ,
        UPPERCASE_LETTERS{

            @Override
            public long parse(String s) {
                return LOWERCASE_LETTERS.parse(s);
            }

            @Override
            public String toString(long value) {
                if (value < 0L) {
                    return '-' + this.toString(-value);
                }
                if (value == 0L) {
                    throw new NumberFormatException();
                }
                if (value <= 26L) {
                    return String.valueOf((char)(value + 65L - 1L));
                }
                return this.toString(value / 26L) + (char)(value % 26L + 65L - 1L);
            }
        }
        ,
        LOWERCASE_ROMAN_NUMERALS{
            private final String[][] ds = new String[][]{" i ii iii iv v vi vii viii ix".split(" "), " x xx xxx xl l lx lxx lxxx lc".split(" "), " c cc ccc cd d dc dcc dccc cm".split(" "), " m mm mmm mmmm mmmmm mmmmmm mmmmmmm mmmmmmmm mmmmmmmmm".split(" ")};

            @Override
            public long parse(String s) {
                if (s.isEmpty()) {
                    throw new NumberFormatException();
                }
                s = s.toLowerCase();
                long result = 0L;
                for (int i = 3; i >= 0; --i) {
                    int j = 9;
                    while (true) {
                        String d;
                        if (s.startsWith(d = this.ds[i][j])) break;
                        --j;
                    }
                    result = 10L * result + (long)j;
                }
                return result;
            }

            @Override
            public String toString(long value) {
                if (value == 0L) {
                    throw new NumberFormatException();
                }
                if (value < 0L) {
                    return '-' + this.toString(-value);
                }
                if (value >= 10000L) {
                    throw new NumberFormatException();
                }
                if (value <= 9L) {
                    return this.ds[0][(int)value];
                }
                StringBuilder sb = new StringBuilder();
                if (value >= 1000L) {
                    sb.append(this.ds[3][(int)value / 1000]);
                    value %= 1000L;
                }
                if (value >= 100L) {
                    sb.append(this.ds[2][(int)value / 100]);
                    value %= 100L;
                }
                if (value >= 10L) {
                    sb.append(this.ds[1][(int)value / 10]);
                    value %= 10L;
                }
                if (value >= 1L) {
                    sb.append(this.ds[0][(int)value]);
                }
                return sb.toString();
            }
        }
        ,
        UPPERCASE_ROMAN_LITERALS{

            @Override
            public long parse(String s) {
                return LOWERCASE_ROMAN_NUMERALS.parse(s);
            }

            @Override
            public String toString(long value) {
                return LOWERCASE_ROMAN_NUMERALS.toString().toUpperCase();
            }
        }
        ,
        ARABIC_DIGITS{

            @Override
            public long parse(String s) {
                return Long.parseLong(s);
            }

            @Override
            public String toString(long value) {
                return Long.toString(value);
            }
        };


        public abstract long parse(String var1);

        public abstract String toString(long var1);
    }

    static interface Bulleting {
        public static final Bulleting NONE = new Bulleting(){

            @Override
            public String next() {
                return "";
            }
        };

        public String next();
    }

    public static interface InlineElementFormatter {
        public void format(Html2Txt var1, Element var2, StringBuilder var3) throws HtmlException;
    }

    public static interface BlockElementFormatter {
        public void format(Html2Txt var1, int var2, Bulleting var3, int var4, Alignment var5, Element var6, Consumer<? super CharSequence> var7) throws HtmlException;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        JUSTIFY;

    }

    public static interface HtmlErrorHandler {
        public void warning(HtmlException var1) throws HtmlException;

        public void fatalError(HtmlException var1) throws HtmlException;

        public void error(HtmlException var1) throws HtmlException;
    }

    public static class HtmlException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Node node;

        public HtmlException(Node node, String message) {
            super(message);
            this.node = node;
        }

        @Override
        public String toString() {
            String message;
            String s = this.getClass().getName();
            Locator l = XmlUtil.getLocation((Node)this.node);
            if (l != null) {
                String publicId = l.getPublicId();
                if (publicId != null) {
                    s = s + ", " + publicId;
                }
                s = s + ", line " + l.getLineNumber() + ", column " + l.getColumnNumber();
            }
            if ((message = this.getLocalizedMessage()) != null) {
                s = s + ": " + message;
            }
            return s;
        }
    }
}

