/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.html2txt;

import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.html2txt.Html2Txt;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXParseException;

public final class Main {
    private final Html2Txt html2Txt = new Html2Txt();

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        args = CommandLineOptions.parse((String[])args, (Object)main);
        try {
            switch (args.length) {
                case 1: {
                    main.html2Txt.html2txt(new File(args[0]), (Writer)new PrintWriter(System.out));
                    break;
                }
                case 2: {
                    main.html2Txt.html2txt(new File(args[0]), new File(args[1]));
                    break;
                }
                default: {
                    System.err.println("Invalid number of command line arguments; try \"--help\".");
                    System.exit(1);
                    break;
                }
            }
        }
        catch (SAXParseException spe) {
            String publicId = spe.getPublicId();
            System.err.println((publicId != null ? publicId + ", line " : "Line ") + spe.getLineNumber() + ", column " + spe.getColumnNumber() + ": " + spe.getMessage() + '.');
            System.exit(1);
        }
        catch (TransformerException te) {
            SourceLocator l = te.getLocator();
            if (l == null) {
                System.err.println(te.getMessage());
            } else {
                String publicId = l.getPublicId();
                System.err.println((publicId != null ? publicId + ", line " : "Line ") + ", line " + l.getLineNumber() + ", column " + l.getColumnNumber() + ": " + te.getMessage() + '.');
            }
            System.exit(1);
        }
        catch (Html2Txt.HtmlException he) {
            System.err.println(he);
            System.exit(1);
        }
    }

    private Main() {
    }

    @CommandLineOption
    public static void help() throws IOException {
        CommandLineOptions.printResource(Main.class, (String)"main(String[]).txt", (Charset)Charset.forName("UTF-8"), (OutputStream)System.out);
        System.exit(0);
    }

    @CommandLineOption
    public void setPageWidth(int width) {
        this.html2Txt.setPageWidth(width);
    }

    @CommandLineOption
    public void setEncoding(Charset charset) {
        this.html2Txt.setInputCharset(charset);
        this.html2Txt.setOutputCharset(charset);
    }

    @CommandLineOption
    public void setInputEncoding(Charset charset) {
        this.html2Txt.setInputCharset(charset);
    }

    @CommandLineOption
    public void setOutputEncoding(Charset charset) {
        this.html2Txt.setOutputCharset(charset);
    }
}

