/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.html2txt;

import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.xml.XmlUtil;
import de.unkrig.html2txt.Html2Txt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class TableFormatter
implements Html2Txt.BlockElementFormatter {
    TableFormatter() {
    }

    @Override
    public void format(Html2Txt html2Txt, int leftMarginWidth, Html2Txt.Bulleting bulleting, int measure, Html2Txt.Alignment alignment, Element tableElement, Consumer<? super CharSequence> output) throws Html2Txt.HtmlException {
        int[] columnWidths;
        Table table = this.parse(html2Txt, tableElement);
        Cell[][] grid = this.arrange(table);
        int[] columnMeasures = new int[grid[0].length];
        TableFormatter.formatCells(html2Txt, grid, columnMeasures, alignment, table.columnSeparator.length());
        SortedMap<Integer, SortedMap<Integer, Integer>> minimumCellWidths = TableFormatter.computeCellWidths(html2Txt, grid);
        int[] minimumColumnWidths = TableFormatter.computeColumnWidths(minimumCellWidths);
        int minimumTableWidth = TableFormatter.computeTableWidth(minimumColumnWidths, table.leftBorder.length(), table.columnSeparator.length(), table.rightBorder.length());
        if (measure <= minimumTableWidth) {
            columnWidths = minimumColumnWidths;
        } else {
            int[] columnMeasures2 = new int[grid[0].length];
            Arrays.fill(columnMeasures2, Integer.MAX_VALUE);
            TableFormatter.formatCells(html2Txt, grid, columnMeasures2, alignment, table.columnSeparator.length());
            SortedMap<Integer, SortedMap<Integer, Integer>> naturalCellWidths = TableFormatter.computeCellWidths(html2Txt, grid);
            int[] naturalColumnWidths = TableFormatter.computeColumnWidths(naturalCellWidths);
            int naturalTableWidth = TableFormatter.computeTableWidth(naturalColumnWidths, table.leftBorder.length(), table.columnSeparator.length(), table.rightBorder.length());
            if (naturalTableWidth <= measure) {
                columnWidths = naturalColumnWidths;
                if (table.is100Percent) {
                    TableFormatter.spreadEvenly(measure - naturalTableWidth, columnWidths);
                    TableFormatter.formatCells(html2Txt, grid, columnWidths, alignment, table.columnSeparator.length());
                }
            } else {
                columnWidths = minimumColumnWidths;
                TableFormatter.spreadEvenly(measure - minimumTableWidth, columnWidths);
                TableFormatter.formatCells(html2Txt, grid, columnWidths, alignment, table.columnSeparator.length());
            }
        }
        SortedMap<Integer, SortedMap<Integer, Integer>> cellHeights = TableFormatter.computeCellHeights(html2Txt, grid);
        int[] rowHeights = TableFormatter.computeRowHeights(cellHeights);
        Producer[] cellContents = new Producer[grid[0].length];
        int rowno = 0;
        while (true) {
            char c;
            char c2 = rowno == 0 ? table.topBorder : (c = rowno == grid.length - 1 ? table.bottomBorder : table.rowSeparator);
            if (c != '\u0000') {
                StringBuilder sb = new StringBuilder();
                sb.append(StringUtil.repeat((int)leftMarginWidth, (char)' '));
                sb.append(StringUtil.repeat((int)table.leftBorder.length(), (char)'+'));
                for (int colno = 0; colno < grid[0].length; ++colno) {
                    if (cellContents[colno] != null) {
                        sb.append((String)cellContents[colno].produce());
                    } else {
                        char c22 = table.headingRowSeparator != '\u0000' && rowno >= 1 && grid[rowno - 1][colno].isTh ? table.headingRowSeparator : c;
                        sb.append(StringUtil.repeat((int)columnWidths[colno], (char)c22));
                    }
                    char x = (rowno == 0 || colno != grid[0].length - 1 && grid[rowno - 1][colno] == grid[rowno - 1][colno + 1]) && colno != grid[0].length - 1 && grid[rowno][colno] == grid[rowno][colno + 1] ? (char)c : (char)'+';
                    sb.append(StringUtil.repeat((int)(colno == grid[0].length - 1 ? table.rightBorder : table.columnSeparator).length(), (char)x));
                }
                output.consume((Object)sb.toString());
            }
            if (rowno == grid.length) break;
            Cell[] row = grid[rowno];
            ArrayList<Producer> segments = new ArrayList<Producer>();
            segments.add(ProducerUtil.constantProducer((Object)StringUtil.repeat((int)leftMarginWidth, (char)' ')));
            segments.add(ProducerUtil.constantProducer((Object)table.leftBorder));
            int colno = 0;
            while (colno < row.length) {
                int colno2;
                Cell cell = row[colno];
                int w = columnWidths[colno];
                for (colno2 = colno + 1; colno2 < row.length && row[colno2] == cell; ++colno2) {
                    w += table.columnSeparator.length() + columnWidths[colno2];
                }
                Producer p = cellContents[colno];
                if (p == null) {
                    List<CharSequence> lines = cell.lines;
                    assert (lines != null);
                    p = ProducerUtil.concat(Html2Txt.rightPad((Producer<? extends CharSequence>)ProducerUtil.fromIterator(lines.iterator(), (boolean)true), w, ' '), (Producer)ProducerUtil.constantProducer((Object)StringUtil.repeat((int)w, (char)' ')));
                }
                cellContents[colno] = rowno < grid.length - 1 && grid[rowno + 1][colno] == cell ? p : null;
                segments.add(p);
                colno = colno2;
                segments.add(ProducerUtil.constantProducer((Object)(colno == row.length ? table.rightBorder : table.columnSeparator)));
            }
            for (int i = 0; i < rowHeights[rowno]; ++i) {
                StringBuilder sb = new StringBuilder();
                for (Producer p : segments) {
                    sb.append((String)p.produce());
                }
                output.consume((Object)sb.toString());
            }
            ++rowno;
        }
    }

    public static void formatCells(Html2Txt html2Txt, Cell[][] grid, int[] columnMeasures, Html2Txt.Alignment alignment, int columnSeparatorWidth) throws Html2Txt.HtmlException {
        for (int rowno = 0; rowno < grid.length; ++rowno) {
            Cell[] row = grid[rowno];
            assert (row.length == columnMeasures.length) : row.length + "!=" + columnMeasures.length;
            int colno = 0;
            while (colno < row.length) {
                int colno2;
                Cell cell = row[colno];
                if (rowno > 0 && grid[rowno - 1][colno] == cell) {
                    ++colno;
                    continue;
                }
                if (colno > 0 && row[colno - 1] == cell) {
                    ++colno;
                    continue;
                }
                int columnMeasure = columnMeasures[colno];
                for (colno2 = colno + 1; colno2 < row.length && row[colno2] == cell; ++colno2) {
                    columnMeasure += columnSeparatorWidth + columnMeasures[colno2];
                }
                colno = colno2;
                cell.lines = new ArrayList<CharSequence>();
                ArrayList<CharSequence> lines = cell.lines;
                html2Txt.formatBlocks(0, Html2Txt.Bulleting.NONE, Html2Txt.Bulleting.NONE, columnMeasure, alignment, cell.childNodes, (Consumer<? super CharSequence>)ConsumerUtil.addToCollection(lines));
                cell.width = Html2Txt.maxLength(lines);
                cell.height = lines.size();
            }
        }
    }

    private Cell[][] arrange(Table table) {
        ArrayList cells = new ArrayList();
        int rowno = 0;
        for (Tr tr : table.trs) {
            int colno = 0;
            for (Td td : tr.tds) {
                block2: while (true) {
                    for (int j = 0; j < td.rowspan; ++j) {
                        block16: {
                            List row;
                            if (cells.size() <= rowno + j || (row = (List)cells.get(rowno + j)) == null) continue;
                            for (int i = 0; i < td.colspan; ++i) {
                                if (row.size() <= colno + i || row.get(colno + i) == null) {
                                    continue;
                                }
                                break block16;
                            }
                            continue;
                        }
                        ++colno;
                        continue block2;
                    }
                    break;
                }
                Cell cell = new Cell(td.isTh, td.childNodes);
                for (int j = 0; j < td.rowspan; ++j) {
                    while (cells.size() <= rowno + j) {
                        cells.add(new ArrayList());
                    }
                    List row = (List)cells.get(rowno + j);
                    for (int i = 0; i < td.colspan; ++i) {
                        while (row.size() <= colno + i) {
                            row.add(null);
                        }
                        Cell prev = row.set(colno + i, cell);
                        assert (prev == null);
                    }
                }
                colno += td.colspan;
            }
            ++rowno;
        }
        int nrows = cells.size();
        int ncols = 0;
        for (List list : cells) {
            if (list.size() <= ncols) continue;
            ncols = list.size();
        }
        Cell[][] result = new Cell[nrows][ncols];
        rowno = 0;
        for (List list : cells) {
            int colno = 0;
            for (Cell cell : list) {
                result[rowno][colno++] = cell;
            }
            ++rowno;
        }
        Cell cell = new Cell(false, Collections.<Node>emptyList());
        cell.height = 0;
        cell.width = 0;
        cell.lines = Collections.emptyList();
        for (rowno = 0; rowno < result.length; ++rowno) {
            Cell[] cellArray = result[rowno];
            for (int colno = 0; colno < cellArray.length; ++colno) {
                if (cellArray[colno] != null) continue;
                cellArray[colno] = cell;
            }
        }
        return result;
    }

    private static int computeTableWidth(int[] columnWidths, int leftBorderWidth, int columnSeparatorWidth, int rightBorderWidth) {
        return leftBorderWidth + rightBorderWidth + (columnWidths.length - 1) * columnSeparatorWidth + TableFormatter.sum(columnWidths);
    }

    private static int sum(int[] list) {
        int result = 0;
        int[] nArray = list;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            result += i2.intValue();
        }
        return result;
    }

    private static int[] computeColumnWidths(SortedMap<Integer, SortedMap<Integer, Integer>> cellWidths) {
        int ncols = 0;
        for (Map.Entry<Integer, SortedMap<Integer, Integer>> e : cellWidths.entrySet()) {
            int colspan = e.getKey();
            SortedMap<Integer, Integer> colno2Width = e.getValue();
            for (Integer colno : colno2Width.keySet()) {
                int m = colno + colspan;
                if (m <= ncols) continue;
                ncols = m;
            }
        }
        int[] result = new int[ncols];
        for (Map.Entry<Integer, SortedMap<Integer, Integer>> e : cellWidths.entrySet()) {
            int colspan = e.getKey();
            SortedMap<Integer, Integer> colno2Width = e.getValue();
            for (Map.Entry<Integer, Integer> e2 : colno2Width.entrySet()) {
                int colno = e2.getKey();
                int cellWidth = e2.getValue();
                int tcw = 0;
                for (int i = colno; i < colno + colspan; ++i) {
                    tcw += result[i];
                }
                if (tcw >= cellWidth) continue;
                int excess = cellWidth - tcw;
                TableFormatter.spreadEvenly(excess, result, colno, colspan);
            }
        }
        return result;
    }

    private static int[] computeRowHeights(SortedMap<Integer, SortedMap<Integer, Integer>> cellHeights) {
        return TableFormatter.computeColumnWidths(cellHeights);
    }

    private static void spreadEvenly(int excess, int[] values) {
        TableFormatter.spreadEvenly(excess, values, 0, values.length);
    }

    private static void spreadEvenly(int excess, int[] values, int off, int len) {
        if (excess == 0) {
            return;
        }
        int n = excess / len;
        int nfrac = excess - len * n;
        int x = 0;
        for (int i = 0; i < len; ++i) {
            int w = values[off + i] + n;
            if ((x += nfrac) > len) {
                x -= len;
            }
            values[off + i] = ++w;
        }
    }

    private Table parse(Html2Txt html2Txt, Element tableElement) throws Html2Txt.HtmlException {
        String rightBorder;
        String columnSeparator;
        String leftBorder;
        char headingRowSeparator;
        char bottomBorder;
        char rowSeparator;
        char topBorder;
        String border;
        Attr borderAttribute = tableElement.getAttributeNode("border");
        String string = border = borderAttribute == null ? null : borderAttribute.getValue();
        if ("1".equals(border)) {
            topBorder = '-';
            rowSeparator = '-';
            bottomBorder = '-';
            headingRowSeparator = '=';
            leftBorder = "|";
            columnSeparator = "|";
            rightBorder = "|";
        } else if ("2".equals(border)) {
            topBorder = '=';
            rowSeparator = '=';
            bottomBorder = '=';
            headingRowSeparator = '=';
            leftBorder = "||";
            columnSeparator = "||";
            rightBorder = "||";
        } else {
            topBorder = '\u0000';
            rowSeparator = '\u0000';
            headingRowSeparator = '\u0000';
            bottomBorder = '\u0000';
            leftBorder = "";
            rightBorder = "";
            columnSeparator = " ";
        }
        Attr s = tableElement.getAttributeNode("width");
        boolean is100Percent = "100%".equals(s);
        ArrayList<Tr> trs = new ArrayList<Tr>();
        for (Node trNode : XmlUtil.iterable((NodeList)tableElement.getChildNodes())) {
            if (trNode.getNodeType() == 3 && trNode.getTextContent().trim().length() == 0) continue;
            if (Html2Txt.isElement(trNode, "tr") == null) {
                html2Txt.htmlErrorHandler.warning(new Html2Txt.HtmlException(trNode, "Expected \"<tr>\" instead of \"" + XmlUtil.toString((Node)trNode) + "\" inside \"<table>\""));
                continue;
            }
            ArrayList<Td> tds = new ArrayList<Td>();
            for (Node n : XmlUtil.iterable((NodeList)trNode.getChildNodes())) {
                int rowspan;
                int colspan;
                boolean isTh;
                if (n.getNodeType() == 3 && n.getTextContent().trim().length() == 0) continue;
                Element tdElement = Html2Txt.isElement(n, "th");
                if (tdElement != null) {
                    isTh = true;
                } else {
                    tdElement = Html2Txt.isElement(n, "td");
                    if (tdElement != null) {
                        isTh = false;
                    } else {
                        html2Txt.htmlErrorHandler.warning(new Html2Txt.HtmlException(n, "Expected \"<td>\" or \"<th>\""));
                        continue;
                    }
                }
                try {
                    colspan = Math.max(1, Integer.parseInt(tdElement.getAttributeNode("colspan").getValue()));
                }
                catch (Exception e) {
                    colspan = 1;
                }
                try {
                    rowspan = Math.max(1, Integer.parseInt(tdElement.getAttributeNode("rowspan").getValue()));
                }
                catch (Exception e) {
                    rowspan = 1;
                }
                tds.add(new Td(isTh, rowspan, colspan, XmlUtil.iterable((NodeList)tdElement.getChildNodes())));
            }
            trs.add(new Tr(tds));
        }
        return new Table(topBorder, rowSeparator, headingRowSeparator, bottomBorder, leftBorder, columnSeparator, rightBorder, is100Percent, trs);
    }

    private static SortedMap<Integer, SortedMap<Integer, Integer>> computeCellWidths(Html2Txt html2Txt, Cell[][] grid) {
        TreeMap<Integer, SortedMap<Integer, Integer>> result = new TreeMap<Integer, SortedMap<Integer, Integer>>();
        for (int rowno = 0; rowno < grid.length; ++rowno) {
            Cell[] row = grid[rowno];
            int colno = 0;
            while (colno < row.length) {
                Integer prev;
                int colno2;
                Cell cell = grid[rowno][colno];
                for (colno2 = colno + 1; colno2 < row.length && row[colno2] == cell; ++colno2) {
                }
                int colspan = colno2 - colno;
                TreeMap<Integer, Integer> x = (TreeMap<Integer, Integer>)result.get(colspan);
                if (x == null) {
                    x = new TreeMap<Integer, Integer>();
                    result.put(colspan, x);
                }
                if ((prev = (Integer)x.get(colno)) == null || prev < cell.width) {
                    x.put(colno, cell.width);
                }
                colno = colno2;
            }
        }
        return result;
    }

    private static SortedMap<Integer, SortedMap<Integer, Integer>> computeCellHeights(Html2Txt html2Txt, Cell[][] grid) {
        TreeMap<Integer, SortedMap<Integer, Integer>> result = new TreeMap<Integer, SortedMap<Integer, Integer>>();
        for (int rowno = 0; rowno < grid.length; ++rowno) {
            Cell[] row = grid[rowno];
            for (int colno = 0; colno < row.length; ++colno) {
                Integer prev;
                int rowno2;
                Cell cell = grid[rowno][colno];
                if (rowno > 0 && grid[rowno - 1][colno] == cell) continue;
                for (rowno2 = rowno + 1; rowno2 < grid.length && grid[rowno2][colno] == cell; ++rowno2) {
                }
                int rowspan = rowno2 - rowno;
                TreeMap<Integer, Integer> x = (TreeMap<Integer, Integer>)result.get(rowspan);
                if (x == null) {
                    x = new TreeMap<Integer, Integer>();
                    result.put(rowspan, x);
                }
                if ((prev = (Integer)x.get(rowno)) != null && prev >= cell.height) continue;
                x.put(rowno, cell.height);
            }
        }
        return result;
    }

    class Td {
        final boolean isTh;
        final int rowspan;
        final int colspan;
        final Iterable<Node> childNodes;

        Td(boolean isTh, int rowspan, int colspan, Iterable<Node> childNodes) {
            assert (rowspan >= 1);
            assert (colspan >= 1);
            this.isTh = isTh;
            this.rowspan = rowspan;
            this.colspan = colspan;
            this.childNodes = childNodes;
        }
    }

    class Tr {
        final List<Td> tds;

        Tr(List<Td> tds) {
            this.tds = tds;
        }
    }

    class Table {
        final char topBorder;
        final char rowSeparator;
        final char headingRowSeparator;
        final char bottomBorder;
        final String leftBorder;
        final String columnSeparator;
        final String rightBorder;
        final List<Tr> trs;
        private final boolean is100Percent;

        Table(char topBorder, char rowSeparator, char headingRowSeparator, char bottomBorder, String leftBorder, String columnSeparator, String rightBorder, boolean is100Percent, List<Tr> trs) {
            this.topBorder = topBorder;
            this.rowSeparator = rowSeparator;
            this.headingRowSeparator = headingRowSeparator;
            this.bottomBorder = bottomBorder;
            this.leftBorder = leftBorder;
            this.columnSeparator = columnSeparator;
            this.rightBorder = rightBorder;
            this.is100Percent = is100Percent;
            this.trs = trs;
        }
    }

    class Cell {
        final boolean isTh;
        final Iterable<Node> childNodes;
        @Nullable
        List<CharSequence> lines;
        int width;
        int height;

        Cell(boolean isTh, Iterable<Node> childNodes) {
            this.isTh = isTh;
            this.childNodes = childNodes;
        }
    }
}

