/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.javapatterns;

import de.unruh.javapatterns.InvalidPatternMatch;
import de.unruh.javapatterns.MatchManager;
import de.unruh.javapatterns.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Capture<T>
extends Pattern<T> {
    private final String name;
    private T value;
    private boolean assigned = false;

    @Override
    public String toString() {
        return this.name;
    }

    @Contract(pure=true)
    Capture(@NotNull String name) {
        this.name = name;
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    void clear() {
        this.assigned = false;
    }

    @Contract(pure=true)
    public T v() {
        if (!this.assigned) {
            throw new InvalidPatternMatch("Reading undefined capture variable " + this.name);
        }
        return this.value;
    }

    @Override
    public void apply(@NotNull MatchManager mgr, @Nullable T value) {
        if (this.assigned) {
            throw new InvalidPatternMatch("Re-assigned " + this.name + " in pattern match");
        }
        mgr.assigned(this);
        this.assigned = true;
        this.value = value;
    }
}

