/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.javapatterns;

import de.unruh.javapatterns.MatchManager;
import de.unruh.javapatterns.MatchSupplier;
import de.unruh.javapatterns.Pattern;
import de.unruh.javapatterns.PatternMatchReject;
import de.unruh.javapatterns.PatternResult;
import de.unruh.javapatterns.PatternResultNone;
import de.unruh.javapatterns.PatternResultSome;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Case<In, Return, Exn extends Throwable> {
    private final Pattern<? super In> pattern;
    private final MatchSupplier<? extends Return, Exn> action;

    @Contract(pure=true)
    Case(@NotNull Pattern<? super In> pattern, @NotNull MatchSupplier<? extends Return, Exn> action) {
        this.pattern = pattern;
        this.action = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    PatternResult<Return> apply(@NotNull MatchManager mgr, @Nullable In t) throws Exn {
        try {
            this.pattern.apply(mgr, t);
            PatternResultSome<Return> patternResultSome = new PatternResultSome<Return>(this.action.call());
            return patternResultSome;
        }
        catch (PatternMatchReject e) {
            PatternResultNone patternResultNone = new PatternResultNone();
            return patternResultNone;
        }
        finally {
            mgr.clearCaptured();
        }
    }
}

