/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.javapatterns;

import de.unruh.javapatterns.Capture;
import de.unruh.javapatterns.PatternMatchReject;
import de.unruh.javapatterns.PatternRunnable;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MatchManager {
    @NotNull
    private final Deque<Capture<?>> captured = new ArrayDeque(10);

    @Contract(pure=true)
    MatchManager() {
    }

    <T> void assigned(@NotNull Capture<T> x) {
        this.captured.add(x);
    }

    void clearCaptured() {
        for (Capture<?> capture : this.captured) {
            capture.clear();
        }
        this.captured.clear();
    }

    public boolean protectedBlock(@NotNull PatternRunnable block) {
        int size = this.captured.size();
        try {
            block.run();
        }
        catch (PatternMatchReject e) {
            while (this.captured.size() > size) {
                Capture<?> capture = this.captured.pop();
                capture.clear();
            }
            return false;
        }
        return true;
    }
}

