/*
 * Decompiled with CFR 0.152.
 */
package de.unruh.javapatterns;

import de.unruh.javapatterns.Capture;
import de.unruh.javapatterns.InvalidPatternMatch;
import de.unruh.javapatterns.MatchManager;
import de.unruh.javapatterns.Pattern;
import de.unruh.javapatterns.PatternMatchReject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Patterns {
    @NotNull
    public static final Pattern<Object> Any = new Pattern<Object>(){

        @Override
        public void apply(@NotNull MatchManager mgr, @Nullable Object value) {
        }

        @Override
        public String toString() {
            return "_";
        }
    };
    @NotNull
    public static final Pattern<Object> Null = new Pattern<Object>(){

        @Override
        public void apply(@NotNull MatchManager mgr, @Nullable Object value) throws PatternMatchReject {
            if (value != null) {
                5.reject();
            }
        }

        @Override
        public String toString() {
            return "null";
        }
    };

    @Contract(pure=true)
    private Patterns() {
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> Is(final @Nullable T expected) {
        return new Pattern<T>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable T value) throws PatternMatchReject {
                if (!Objects.equals(expected, value)) {
                    1.reject();
                }
            }

            @Override
            public String toString() {
                return "=" + expected;
            }
        };
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> Is(final @NotNull Supplier<T> expected) {
        return new Pattern<T>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable T value) throws PatternMatchReject {
                if (!Objects.equals(expected.get(), value)) {
                    2.reject();
                }
            }

            @Override
            public String toString() {
                return "=" + expected;
            }
        };
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> Is(@NotNull Capture<T> expected) {
        return Patterns.Is(expected::v);
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> Is(final @NotNull Predicate<? super T> predicate) {
        return new Pattern<T>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable T value) throws PatternMatchReject {
                if (!predicate.test(value)) {
                    3.reject();
                }
            }

            @Override
            public String toString() {
                return "Pred(...)";
            }
        };
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> NotNull(final @NotNull @NotNull Pattern<@NotNull ? super T> pattern) {
        return new Pattern<T>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable T value) throws PatternMatchReject {
                if (value == null) {
                    6.reject();
                }
                pattern.apply(mgr, value);
            }

            @Override
            public String toString() {
                return "null";
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> And(final Pattern<? super T> ... patterns) {
        return new Pattern<T>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable T value) throws PatternMatchReject {
                for (Pattern pattern : patterns) {
                    pattern.apply(mgr, value);
                }
            }

            @Override
            public String toString() {
                StringJoiner joiner = new StringJoiner(", ");
                for (Pattern pattern : patterns) {
                    joiner.add(pattern.toString());
                }
                return "And(" + joiner + ")";
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> Or(final Pattern<? super T> ... patterns) {
        return new Pattern<T>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable T value) throws PatternMatchReject {
                if (patterns.length == 0) {
                    8.reject();
                }
                for (int i = 0; i < patterns.length - 1; ++i) {
                    Pattern pattern = patterns[i];
                    if (!mgr.protectedBlock(() -> pattern.apply(mgr, value))) continue;
                    return;
                }
                patterns[patterns.length - 1].apply(mgr, value);
            }

            @Override
            public String toString() {
                StringJoiner joiner = new StringJoiner(", ");
                for (Pattern pattern : patterns) {
                    joiner.add(pattern.toString());
                }
                return "Or(" + joiner + ")";
            }
        };
    }

    @NotNull
    @Contract(pure=true, value="_, _ -> new")
    public static <U> Pattern<Object> Instance(final @NotNull Class<U> clazz, final @NotNull Pattern<? super U> pattern) {
        return new Pattern<Object>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable Object value) throws PatternMatchReject {
                if (!clazz.isInstance(value)) {
                    9.reject();
                }
                pattern.apply(mgr, value);
            }

            @Override
            public String toString() {
                return "Instance(" + clazz.getSimpleName() + "," + pattern + ")";
            }
        };
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T> NoMatch(final @NotNull Pattern<? super T> pattern) {
        return new Pattern<T>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable T value) throws PatternMatchReject {
                boolean matched = mgr.protectedBlock(() -> pattern.apply(mgr, value));
                if (matched) {
                    10.reject();
                }
            }

            @Override
            public String toString() {
                return "NoMatch(" + pattern + ")";
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static <T> Pattern<T[]> Array(final Pattern<? super T> ... patterns) {
        return new Pattern<T[]>(){

            @Override
            public void apply(@NotNull MatchManager mgr, @Nullable @Nullable T @Nullable [] value) throws PatternMatchReject {
                if (value == null) {
                    11.reject();
                }
                if (value.length != patterns.length) {
                    11.reject();
                }
                for (int i = 0; i < patterns.length; ++i) {
                    patterns[i].apply(mgr, value[i]);
                }
            }

            @Override
            public String toString() {
                StringJoiner joiner = new StringJoiner(", ");
                for (Pattern pattern : patterns) {
                    joiner.add(pattern.toString());
                }
                return "Array(" + joiner + ")";
            }
        };
    }

    public static abstract class Instance<U>
    extends Pattern<U> {
        private final Pattern<Object> instancePattern;
        private final Pattern<? super U> pattern;
        private final Type typeU;

        @Contract(pure=true)
        protected Instance(@NotNull Pattern<? super U> pattern) {
            Class clazz;
            if (this.getClass().getSuperclass() != Instance.class) {
                throw new InvalidPatternMatch("A subclass of a subclass of " + Instance.class + " was created. This is not the intended use.");
            }
            Type superclass = this.getClass().getGenericSuperclass();
            this.typeU = ((ParameterizedType)superclass).getActualTypeArguments()[0];
            if (this.typeU instanceof ParameterizedType) {
                clazz = (Class)((ParameterizedType)this.typeU).getRawType();
            } else if (this.typeU instanceof Class) {
                clazz = (Class)this.typeU;
            } else {
                throw new InvalidPatternMatch("Type parameter of " + Instance.class.getName() + " must be a class, not " + this.typeU + " " + this.typeU.getClass());
            }
            this.instancePattern = Patterns.Instance(clazz, pattern);
            this.pattern = pattern;
        }

        @Override
        public void apply(@NotNull MatchManager mgr, @Nullable U value) throws PatternMatchReject {
            this.instancePattern.apply(mgr, value);
        }

        @Override
        public String toString() {
            return "(" + this.pattern + " : " + this.typeU + ")";
        }
    }
}

