/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.startuphook;

import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.startuphook.RuntimeHelper;
import de.valtech.aecu.startuphook.ServiceResourceResolverService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AecuCloudStartupService.class}, immediate=true, name="AECU cloud startup hook")
public class AecuCloudStartupService {
    private static final String GROOVY_CONSOLE_BUNDLE_SYMBOLIC_NAME = "aem-groovy-console-bundle";
    private static final String STAR_IMPORT_EXTENSION_PROVIDER = "StarImportExtensionProvider";
    private static final String BINDING_EXTENSION_PROVIDER = "BindingExtensionProvider";
    private static final String DEFAULT_EXTENSION_SERVICE = "be.orbinson.aem.groovy.console.extension.impl.DefaultExtensionService";
    private static final Logger LOGGER = LoggerFactory.getLogger(AecuCloudStartupService.class);
    private static final int WAIT_PERIOD = 30;
    private static final int WAIT_INTERVALS = 10;
    private static final int MIGRATION_TIMEOUT = 1800;
    @Reference
    private AecuService aecuService;
    @Reference
    private ServiceResourceResolverService resourceResolverService;
    @Reference
    private ServiceComponentRuntime serviceComponentRuntime;
    private BundleContext bundleContext;

    @Activate
    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        Runnable runnable = this::checkAndRunMigration;
        Thread thread = new Thread(runnable);
        thread.start();
    }

    protected void checkAndRunMigration() {
        ResourceResolver resourceResolver = this.getResourceResolver();
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        boolean isCompositeNodeStore = RuntimeHelper.isCompositeNodeStore(session);
        if (isCompositeNodeStore && !this.isMigrationInProgress()) {
            try {
                if (!this.waitForServices()) {
                    LOGGER.error("Groovy extension services seem to be not bound");
                    throw new IllegalStateException("Groovy extension services seem to be not bound");
                }
                Thread.sleep(60000L);
                this.startAecuMigration();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted", (Throwable)e);
            }
        }
    }

    protected boolean isMigrationInProgress() {
        try {
            List historyEntries = this.aecuService.getHistory(0, 1);
            if (historyEntries.isEmpty() || ((HistoryEntry)historyEntries.get(0)).getState() == HistoryEntry.STATE.FINISHED) {
                return false;
            }
            Date startTime = ((HistoryEntry)historyEntries.get(0)).getStart();
            Date limitTime = new Date(System.currentTimeMillis() - 1800000L);
            return limitTime.before(startTime);
        }
        catch (AecuException e) {
            LOGGER.error("Unable to read history");
            return true;
        }
    }

    protected boolean waitForServices() throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            if (this.servicesAreOk()) {
                return true;
            }
            Thread.sleep(30000L);
            LOGGER.debug("Services not yet injected, waiting");
        }
        return false;
    }

    private boolean servicesAreOk() {
        Bundle bundle = Arrays.stream(this.bundleContext.getBundles()).filter(b -> GROOVY_CONSOLE_BUNDLE_SYMBOLIC_NAME.equals(b.getSymbolicName())).findFirst().orElse(null);
        if (bundle == null) {
            return false;
        }
        ComponentDescriptionDTO componentDescription = this.serviceComponentRuntime.getComponentDescriptionDTO(bundle, DEFAULT_EXTENSION_SERVICE);
        if (componentDescription == null || !this.serviceComponentRuntime.isComponentEnabled(componentDescription)) {
            return false;
        }
        Collection componentConfigurations = this.serviceComponentRuntime.getComponentConfigurationDTOs(componentDescription);
        int satisfied = 0;
        for (ComponentConfigurationDTO componentConfiguration : componentConfigurations) {
            for (SatisfiedReferenceDTO satisfiedReference : componentConfiguration.satisfiedReferences) {
                if (!BINDING_EXTENSION_PROVIDER.equals(satisfiedReference.name) && !STAR_IMPORT_EXTENSION_PROVIDER.equals(satisfiedReference.name) || satisfiedReference.boundServices.length < 2) continue;
                ++satisfied;
            }
        }
        return satisfied == 2;
    }

    void startAecuMigration() {
        try {
            LOGGER.info("AECU migration started");
            this.aecuService.executeWithInstallHookHistory("/apps/aecu-scripts");
            LOGGER.info("AECU migration finished");
        }
        catch (AecuException ae) {
            LOGGER.error("Error while executing AECU migration", (Throwable)ae);
        }
    }

    private ResourceResolver getResourceResolver() {
        try {
            return this.resourceResolverService.getAdminResourceResolver();
        }
        catch (LoginException le) {
            throw new IllegalStateException("Error while logging in", le);
        }
    }
}

