/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.startuphook;

import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.api.service.AecuService;
import de.valtech.aecu.api.service.HistoryEntry;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobConsumer.class}, property={"job.topics=de/valtech/aecu/cloud/AecuStartupJobTopic"})
public class AecuStartupJobConsumer
implements JobConsumer {
    protected static final String JOB_TOPIC = "de/valtech/aecu/cloud/AecuStartupJobTopic";
    private static final Logger LOGGER = LoggerFactory.getLogger(AecuStartupJobConsumer.class);
    @Reference
    private AecuService aecuService;

    public JobConsumer.JobResult process(Job job) {
        try {
            LOGGER.info("AECU migration started");
            HistoryEntry result = this.aecuService.executeWithInstallHookHistory("/apps/aecu-scripts");
            LOGGER.info("AECU migration finished with result " + result.getResult());
            return JobConsumer.JobResult.OK;
        }
        catch (AecuException ae) {
            LOGGER.error("Error while executing AECU migration", (Throwable)ae);
            return JobConsumer.JobResult.CANCEL;
        }
    }
}

