/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.page;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import de.valtech.aecu.api.service.AecuException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.util.MockHttpServletResponse;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.engine.SlingRequestProcessor;

public class RenderPageAction
implements Action {
    private BindingContext context;
    private int statusCode;
    private String textPresent;
    private String textNotPresent;

    public RenderPageAction(BindingContext context, int statusCode, String textPresent, String textNotPresent) {
        this.context = context;
        this.statusCode = statusCode;
        this.textPresent = textPresent;
        this.textNotPresent = textNotPresent;
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException, AecuException {
        Page page = this.context.getPageManager().getContainingPage(resource);
        if (page == null) {
            throw new AecuException("Unable to find a page for resource " + resource.getPath());
        }
        String successMessage = "Correct page rendering for " + page.getPath();
        RequestResponseFactory requestResponseFactory = this.context.getRequestResponseFactory();
        SlingRequestProcessor requestProcessor = this.context.getSlingRequestProcessor();
        String requestPath = page.getPath() + ".html";
        HttpServletRequest req = requestResponseFactory.createRequest("GET", requestPath);
        WCMMode.DISABLED.toRequest((ServletRequest)req);
        MockHttpServletResponse resp = this.createResponse();
        try {
            requestProcessor.processRequest(req, (HttpServletResponse)resp, this.context.getResolver());
            if (resp.getStatus() != this.statusCode) {
                throw new AecuException(requestPath + " returned " + resp.getStatus() + " instead of " + this.statusCode);
            }
            String html = resp.getOutput().toString();
            if (StringUtils.isNotBlank((CharSequence)this.textPresent) && !html.contains(this.textPresent)) {
                throw new AecuException(requestPath + " did not include " + this.textPresent);
            }
            if (StringUtils.isNotBlank((CharSequence)this.textNotPresent) && html.contains(this.textNotPresent)) {
                throw new AecuException(requestPath + " did include " + this.textNotPresent);
            }
        }
        catch (IOException | ServletException e) {
            throw new PersistenceException("Unable to render " + requestPath);
        }
        return successMessage;
    }

    protected MockHttpServletResponse createResponse() {
        return new MockHttpServletResponse();
    }
}

