/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.page;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.wcm.api.Page;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import javax.jcr.Session;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;

public class ReplicatePageAction
implements Action {
    private boolean activate;
    private BindingContext context;

    public ReplicatePageAction(boolean activate, BindingContext context) {
        this.activate = activate;
        this.context = context;
    }

    @Override
    public String doAction(Resource resource) throws PersistenceException {
        Page page = this.context.getPageManager().getContainingPage(resource);
        if (page == null) {
            return "Unable to find a page for resource " + resource.getPath();
        }
        String action = this.activate ? "activate" : "deactivate";
        String successMessage = "Replicated page " + page.getPath() + " with action " + action;
        if (this.context.isDryRun()) {
            return successMessage;
        }
        try {
            ReplicationActionType type = this.activate ? ReplicationActionType.ACTIVATE : ReplicationActionType.DEACTIVATE;
            this.context.getReplicator().replicate((Session)this.context.getResolver().adaptTo(Session.class), type, page.getPath());
        }
        catch (ReplicationException e) {
            throw new PersistenceException("Unable to replicate " + page.getPath());
        }
        return successMessage;
    }
}

