/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.omnisearch;

import de.valtech.aecu.api.service.ExecutionResult;
import de.valtech.aecu.api.service.HistoryEntry;
import de.valtech.aecu.core.history.HistoryUtil;
import de.valtech.aecu.core.model.history.HistoryDataItem;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.xss.XSSAPI;

@Model(adaptables={SlingHttpServletRequest.class})
public class HistorySearchItem
extends HistoryDataItem {
    private static final String POST_FULLTEXT = "fulltext";
    private static final String DOTS = "...";
    private static final int RELATED_LENGTH = 20;
    private static final String HIGHLIGHT_START = "<span class=\"aecu-highlight\">";
    private static final String HIGHLIGHT_END = "</span>";
    @SlingObject
    private Resource resource;
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService
    private XSSAPI xssApi;
    protected String searchTerm;
    private Resource entryResource;

    @Override
    @PostConstruct
    public void setup() {
        this.history = this.readHistory();
        this.searchTerm = this.request.getParameter(POST_FULLTEXT);
    }

    protected HistoryEntry readHistory() {
        HistoryUtil util = new HistoryUtil();
        this.entryResource = util.getHistoryEntryResource(this.resource);
        return util.readHistoryEntry(this.entryResource);
    }

    protected ExecutionResult readSingleResult() {
        HistoryUtil util = new HistoryUtil();
        return util.readHistorySingleResult(this.resource);
    }

    public String getFragment() {
        if (StringUtils.isBlank((CharSequence)this.searchTerm)) {
            return "";
        }
        ExecutionResult result = this.readSingleResult();
        String snippet = this.extractFromResult(result);
        if (StringUtils.isNotBlank((CharSequence)snippet)) {
            return snippet;
        }
        return "";
    }

    private String extractFromResult(ExecutionResult result) {
        if (StringUtils.containsIgnoreCase((CharSequence)result.getPath(), (CharSequence)this.searchTerm)) {
            return this.createSnippet(result.getPath());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)result.getOutput(), (CharSequence)this.searchTerm)) {
            return this.createSnippet(result.getOutput());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)result.getResult(), (CharSequence)this.searchTerm)) {
            return this.createSnippet(result.getResult());
        }
        if (result.getFallbackResult() != null) {
            return this.extractFromResult(result.getFallbackResult());
        }
        return "";
    }

    private String createSnippet(String text) {
        int position = StringUtils.indexOfIgnoreCase((CharSequence)text, (CharSequence)this.searchTerm);
        if (position == -1) {
            return "";
        }
        int start = 0;
        int end = text.length();
        if (position > 22) {
            start = position - 20;
        }
        if (position + this.searchTerm.length() + 20 < text.length()) {
            end = position + this.searchTerm.length() + 20;
        }
        String prefix = start > 0 ? DOTS : "";
        String postfix = end < text.length() - 3 ? DOTS : "";
        String snippet = prefix + text.substring(start, end) + postfix;
        return this.highlight(snippet);
    }

    private String highlight(String snippet) {
        String escapedSnippet = this.xssApi.encodeForHTML(snippet);
        Pattern pattern = Pattern.compile("(" + Pattern.quote(this.searchTerm) + ")", 2);
        return pattern.matcher(escapedSnippet).replaceAll("<span class=\"aecu-highlight\">$1</span>");
    }

    public String getSelectedScript() {
        Resource scriptResource = this.resource;
        if ("fallback".equals(this.resource.getName())) {
            scriptResource = scriptResource.getParent();
        }
        return (String)scriptResource.getValueMap().get("path", String.class);
    }

    public String getRunPath() {
        return this.entryResource.getPath();
    }
}

