/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.util.PageUtil;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class CopyResourceToRelativePath
implements Action {
    private String relativePath;
    private String newName;
    private BindingContext context;

    public CopyResourceToRelativePath(@Nonnull String relativePath, String newName, @Nonnull BindingContext context) {
        this.relativePath = relativePath;
        this.newName = newName;
        this.context = context;
    }

    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        ResourceResolver resourceResolver = this.context.getResolver();
        Resource destinationParentResource = resourceResolver.getResource(resource, this.relativePath);
        if (destinationParentResource != null) {
            String sourcePath = resource.getPath();
            String destinationName = StringUtils.isNotEmpty((CharSequence)this.newName) ? this.newName : resource.getName();
            String destinationPath = destinationParentResource.getPath() + "/" + destinationName;
            PageUtil pageUtil = new PageUtil();
            if (pageUtil.isPageResource(resource)) {
                PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
                try {
                    pageManager.copy(resource, destinationPath, null, false, false, false);
                }
                catch (WCMException | IllegalArgumentException e) {
                    throw new PersistenceException("Unable to copy " + sourcePath + " as " + destinationPath + ": " + e.getMessage());
                }
            }
            if (!this.context.isDryRun()) {
                try {
                    Session session = (Session)resourceResolver.adaptTo(Session.class);
                    session.getWorkspace().copy(sourcePath, destinationPath);
                }
                catch (RepositoryException e) {
                    throw new PersistenceException("Unable to copy " + sourcePath + " as " + destinationPath + ": " + e.getMessage());
                }
            }
            return "Copied " + sourcePath + " to " + destinationPath;
        }
        return "WARNING: could not read copy destination resource " + this.relativePath;
    }
}

