/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.resource;

import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import de.valtech.aecu.core.groovy.console.bindings.actions.Action;
import de.valtech.aecu.core.groovy.console.bindings.actions.util.PageUtil;
import de.valtech.aecu.core.groovy.console.bindings.impl.BindingContext;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class MoveResourceToRelativePath
implements Action {
    private String relativePath;
    private BindingContext context;

    public MoveResourceToRelativePath(@Nonnull String relativePath, @Nonnull BindingContext context) {
        this.relativePath = relativePath;
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String doAction(@Nonnull Resource resource) throws PersistenceException {
        ResourceResolver resourceResolver = this.context.getResolver();
        Resource destinationResource = resourceResolver.getResource(resource, this.relativePath);
        if (destinationResource == null) return "WARNING: could not read move destination resource " + this.relativePath;
        String sourceAbsPAth = resource.getPath();
        String destinationAsPath = destinationResource.getPath();
        PageUtil pageUtil = new PageUtil();
        if (pageUtil.isPageResource(resource)) {
            PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            try {
                if (this.context.isDryRun()) return "Moved " + sourceAbsPAth + " to path " + destinationAsPath;
                pageManager.move(resource, destinationAsPath + "/" + resource.getName(), null, false, false, null);
                return "Moved " + sourceAbsPAth + " to path " + destinationAsPath;
            }
            catch (WCMException | IllegalArgumentException e) {
                throw new PersistenceException("Unable to move " + sourceAbsPAth + ": " + e.getMessage());
            }
        } else {
            resourceResolver.move(sourceAbsPAth, destinationAsPath);
        }
        return "Moved " + sourceAbsPAth + " to path " + destinationAsPath;
    }
}

