/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.aecu.core.groovy.console.bindings.actions.util;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class MixinUtil {
    private MixinUtil() {
        throw new UnsupportedOperationException("Cannot instantiate MixinUtil");
    }

    public static boolean hasMixin(@Nonnull Node node, @Nonnull String mixin) throws RepositoryException {
        return Arrays.stream(node.getMixinNodeTypes()).anyMatch(nodeType -> nodeType.isNodeType(mixin));
    }

    public static void ensureMixin(@Nonnull Node node, @Nonnull String mixin) throws RepositoryException {
        if (!MixinUtil.hasMixin(node, mixin) && node.canAddMixin(mixin)) {
            node.addMixin(mixin);
        }
    }
}

