/* Copyright 2015 Sven van der Meer <vdmeer.sven@mykolab.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.vandermeer.asciilist.styles;

import org.apache.commons.lang3.NotImplementedException;

import de.vandermeer.asciilist.AsciiList_Check;

/**
 * Customizable style for nested check lists - {@link AsciiList_Check}.
 *
 * @author     Sven van der Meer &lt;vdmeer.sven@mykolab.com&gt;
 * @version    v0.0.3 build 160301 (01-Mar-16) for Java 1.7
 * @since      v0.0.1
 */
public interface ListStyle_CheckNested extends ListStyle {

	/**
	 * Returns the style for a given level.
	 * @param level the level for the requested style
	 * @return check lists style for a given level
	 * @throws NotImplementedException if requested level is not supported
	 */
	ListStyle_Check getStyle(int level);

}
