/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AbstractAsciiListContext;
import de.vandermeer.asciilist.AbstractAsciiListRenderer;
import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListContext;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.skb.interfaces.strategies.IsCollectionStrategy;
import de.vandermeer.skb.interfaces.strategies.collections.IsSetStrategy;
import de.vandermeer.skb.interfaces.strategies.collections.list.ArrayListStrategy;
import de.vandermeer.skb.interfaces.strategies.collections.set.LinkedHashSetStrategy;
import de.vandermeer.skb.interfaces.transformers.ClusterElementTransformer;
import de.vandermeer.skb.interfaces.transformers.StrBuilder_To_String;
import de.vandermeer.skb.interfaces.transformers.Transformer;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class AbstractAsciiList<C extends AbstractAsciiListContext, I extends AsciiListItem, R extends AbstractAsciiListRenderer<I, C>>
implements AsciiList<C, I, R> {
    public final C ctx;
    protected final Set<I> items;
    protected IsSetStrategy<?, I> defaultStrategy = LinkedHashSetStrategy.create();
    protected R renderer;

    protected AbstractAsciiList(C ctx) {
        this(ctx, null);
    }

    protected AbstractAsciiList(IsSetStrategy<?, I> strategy) {
        this(null, strategy);
    }

    protected AbstractAsciiList(C ctx, IsSetStrategy<?, I> strategy) {
        this.items = strategy == null ? this.defaultStrategy.get() : strategy.get();
        this.ctx = ctx == null ? (AbstractAsciiListContext)this.getNewContext() : ctx;
        Validate.notNull(this.ctx, (String)"could not create any context, all attempts are 'null'", (Object[])new Object[0]);
    }

    @Override
    public C getContext() {
        return this.ctx;
    }

    @Override
    public Set<I> getItems() {
        return this.items;
    }

    public int getLongestLineLength() {
        return 0;
    }

    public Set<I> getRawContent() {
        return this.items;
    }

    public AbstractAsciiListRenderer<I, C> getRenderer() {
        return this.renderer;
    }

    public String render() {
        return new StrBuilder().appendWithSeparators(this.renderer.renderAsCollection(this.getRawContent(), this.ctx), "\n").toString();
    }

    public String render(int width) {
        AbstractAsciiListContext renderCtx = (AbstractAsciiListContext)this.getNewContext();
        renderCtx.copySettings((AsciiListContext)this.ctx);
        renderCtx.inheritSettings((AsciiListContext)this.ctx);
        renderCtx.setWidth(renderCtx.getTextWidth(width + renderCtx.getCalculatedItemString().length()));
        return new StrBuilder().appendWithSeparators(this.renderer.renderAsCollection(this.getRawContent(), (AbstractAsciiListContext)renderCtx), "\n").toString();
    }

    @Override
    public Collection<StrBuilder> renderAsChild(AsciiListContext parentCtx, int parentIndent, int parentIndex) {
        AbstractAsciiListContext renderCtx = (AbstractAsciiListContext)this.getNewContext();
        renderCtx.copySettings((AsciiListContext)this.ctx);
        renderCtx.setParents(ArrayUtils.add((int[])parentCtx.getParentIndex(), (int)parentIndex));
        renderCtx.inheritSettings(parentCtx);
        renderCtx.setLevel(parentCtx.getLevel() + 1);
        renderCtx.setItemMargin(parentIndent);
        renderCtx.setWidth(parentCtx.getWidth() + (renderCtx.getItemMargin() - renderCtx.getCalculatedItemString().length()));
        return this.renderer.renderAsCollection(this.getRawContent(), (AbstractAsciiListContext)renderCtx);
    }

    public Collection<String> renderAsCollection() {
        return ClusterElementTransformer.create().transform(this.renderer.renderAsCollection(this.getRawContent(), this.ctx), (Transformer)StrBuilder_To_String.create(), (IsCollectionStrategy)ArrayListStrategy.create());
    }

    public Collection<String> renderAsCollection(int width) {
        return ClusterElementTransformer.create().transform(((AbstractAsciiListRenderer)this.renderer).renderAsCollection(this.getRawContent(), this.ctx, ((AbstractAsciiListContext)this.ctx).getTextWidth(width)), (Transformer)StrBuilder_To_String.create(), (IsCollectionStrategy)ArrayListStrategy.create());
    }

    @Override
    public AsciiList<?, ?, ?> setRenderer(R renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
        return this;
    }

    public StrBuilder toLog() {
        StrBuilder ret = new StrBuilder();
        for (AsciiListItem i : this.getItems()) {
            ret.append(i.toLog());
            ret.appendNewLine();
        }
        return ret;
    }
}

