/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AsciiListContext;
import de.vandermeer.asciithemes.TA_Frame;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import de.vandermeer.skb.interfaces.translators.CharacterTranslator;
import de.vandermeer.skb.interfaces.translators.HtmlElementTranslator;
import de.vandermeer.skb.interfaces.translators.TargetTranslator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class AbstractAsciiListContext
implements AsciiListContext {
    protected String lineSeparator;
    protected TextAlignment alignment;
    protected CharacterTranslator charTranslator;
    protected TA_Frame frame;
    protected int frameMode;
    protected HtmlElementTranslator htmlElementTranslator;
    protected Character itemChar;
    protected int itemMargin;
    protected Character labelLeftChar;
    protected int labelLeftMargin;
    protected Character labelRightChar;
    protected int labelRightMargin;
    protected String leftLabelString;
    protected int level;
    protected String listEndString;
    protected String listStartString;
    protected int[] parentIndex;
    protected String rightLabelString;
    protected TargetTranslator targetTranslator;
    protected Character textLeftChar;
    protected int textLeftMargin;
    protected Character textRightChar;
    protected int textRightMargin;
    protected int width;

    public AbstractAsciiListContext() {
        this.init();
    }

    @Override
    public AbstractAsciiListContext copySettings(AsciiListContext ctx) {
        this.alignment = ctx.getAlignment();
        this.width = ctx.getWidth();
        this.frame = ctx.getFrame();
        this.frameMode = ctx.getFrameMode();
        this.level = ctx.getLevel();
        this.parentIndex = ArrayUtils.clone((int[])ctx.getParentIndex());
        this.leftLabelString = ctx.getLeftLabelString();
        this.rightLabelString = ctx.getRightLabelString();
        this.listStartString = ctx.getListStart();
        this.listEndString = ctx.getListEnd();
        this.charTranslator = ctx.getCharTranslator();
        this.htmlElementTranslator = ctx.getHtmlElementTranslator();
        this.targetTranslator = ctx.getTargetTranslator();
        this.itemChar = ctx.getItemChar();
        this.labelLeftChar = ctx.getLabelLeftChar();
        this.labelRightChar = ctx.getLabelRightChar();
        this.textLeftChar = ctx.getTextLeftChar();
        this.textRightChar = ctx.getTextRightChar();
        this.itemMargin = ctx.getItemMargin();
        this.labelLeftMargin = ctx.getLabelLeftMargin();
        this.labelRightMargin = ctx.getLabelRightMargin();
        this.textLeftMargin = ctx.getTextLeftMargin();
        this.textRightMargin = ctx.getTextRightMargin();
        return this;
    }

    @Override
    public TextAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public StrBuilder getCalculatedItemString() {
        return this.getItemString(null, 0);
    }

    @Override
    public CharacterTranslator getCharTranslator() {
        return this.charTranslator;
    }

    @Override
    public TA_Frame getFrame() {
        return this.frame;
    }

    @Override
    public int getFrameMode() {
        return this.frameMode;
    }

    @Override
    public HtmlElementTranslator getHtmlElementTranslator() {
        return this.htmlElementTranslator;
    }

    @Override
    public Character getItemChar() {
        return this.itemChar;
    }

    @Override
    public int getItemMargin() {
        return this.itemMargin;
    }

    @Override
    public Character getLabelLeftChar() {
        return this.labelLeftChar;
    }

    @Override
    public int getLabelLeftMargin() {
        return this.labelLeftMargin;
    }

    @Override
    public Character getLabelRightChar() {
        return this.labelRightChar;
    }

    @Override
    public int getLabelRightMargin() {
        return this.labelRightMargin;
    }

    @Override
    public String getLeftLabelString() {
        return this.leftLabelString;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getListEnd() {
        return this.listEndString;
    }

    @Override
    public String getListStart() {
        return this.listStartString;
    }

    @Override
    public int[] getParentIndex() {
        return this.parentIndex;
    }

    @Override
    public String getRightLabelString() {
        return this.rightLabelString;
    }

    @Override
    public TargetTranslator getTargetTranslator() {
        return this.targetTranslator;
    }

    @Override
    public Character getTextLeftChar() {
        return this.textLeftChar;
    }

    @Override
    public int getTextLeftMargin() {
        return this.textLeftMargin;
    }

    @Override
    public Character getTextRightChar() {
        return this.textRightChar;
    }

    @Override
    public int getTextRightMargin() {
        return this.textRightMargin;
    }

    @Override
    public int getTextWidth() {
        return this.getTextWidth(this.width);
    }

    @Override
    public int getTextWidth(int width) {
        return width - this.getCalculatedItemString().length();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public abstract AbstractAsciiListContext inheritSettings(AsciiListContext var1);

    @Override
    public void init() {
        this.alignment = TextAlignment.JUSTIFIED_LEFT;
        this.width = 80;
        this.frame = null;
        this.frameMode = 255;
        this.level = 1;
        this.parentIndex = null;
        this.leftLabelString = null;
        this.rightLabelString = null;
        this.listStartString = null;
        this.listEndString = null;
        this.charTranslator = null;
        this.htmlElementTranslator = null;
        this.targetTranslator = null;
        this.textLeftChar = Character.valueOf(' ');
        this.textRightChar = Character.valueOf(' ');
        this.labelLeftChar = Character.valueOf(' ');
        this.labelRightChar = Character.valueOf(' ');
        this.itemChar = Character.valueOf(' ');
        this.textLeftMargin = 1;
        this.textRightMargin = 0;
        this.labelLeftMargin = 0;
        this.labelRightMargin = 0;
        this.itemMargin = 0;
    }

    @Override
    public AsciiListContext setAlignment(TextAlignment alignment) {
        Validate.notNull((Object)alignment);
        this.alignment = alignment;
        return this;
    }

    @Override
    public AsciiListContext setCharTranslator(CharacterTranslator charTranslator) {
        if (charTranslator != null) {
            this.charTranslator = charTranslator;
            this.htmlElementTranslator = null;
            this.targetTranslator = null;
        }
        return this;
    }

    @Override
    public AsciiListContext setFrame(TA_Frame frame) {
        this.frame = frame;
        return this;
    }

    @Override
    public AsciiListContext setFrameMode(int frameMode) {
        if (frameMode >= 0) {
            this.frameMode = frameMode;
        }
        return this;
    }

    @Override
    public AsciiListContext setHtmlElementTranslator(HtmlElementTranslator htmlElementTranslator) {
        if (htmlElementTranslator != null) {
            this.htmlElementTranslator = htmlElementTranslator;
            this.charTranslator = null;
            this.targetTranslator = null;
        }
        return this;
    }

    @Override
    public AsciiListContext setItemChar(Character c) {
        if (c != null) {
            this.itemChar = c;
        }
        return this;
    }

    @Override
    public AsciiListContext setItemMargin(int margin) {
        if (margin > -1) {
            this.itemMargin = margin;
        }
        return this;
    }

    @Override
    public AsciiListContext setLabelLeftChar(Character c) {
        if (c != null) {
            this.labelLeftChar = c;
        }
        return this;
    }

    @Override
    public AsciiListContext setLabelLeftMargin(int margin) {
        if (margin > -1) {
            this.labelLeftMargin = margin;
        }
        return this;
    }

    @Override
    public AsciiListContext setLabelRightChar(Character c) {
        if (c != null) {
            this.labelRightChar = c;
        }
        return this;
    }

    @Override
    public AsciiListContext setLabelRightMargin(int margin) {
        if (margin > -1) {
            this.labelRightMargin = margin;
        }
        return this;
    }

    @Override
    public AsciiListContext setLeftLabelString(String leftLabel) {
        this.leftLabelString = leftLabel;
        return this;
    }

    @Override
    public AsciiListContext setLevel(int level) {
        if (level > 1) {
            this.level = level;
        }
        return this;
    }

    @Override
    public AsciiListContext setListEnd(String listEnd) {
        this.listEndString = listEnd;
        return this;
    }

    @Override
    public AsciiListContext setListStart(String listStart) {
        this.listStartString = listStart;
        return this;
    }

    @Override
    public AsciiListContext setParents(int[] parentIndex) {
        Validate.notNull((Object)parentIndex);
        this.parentIndex = parentIndex;
        return this;
    }

    @Override
    public AsciiListContext setRightLabelString(String rightLabel) {
        this.rightLabelString = rightLabel;
        return this;
    }

    @Override
    public AsciiListContext setTargetTranslator(TargetTranslator targetTranslator) {
        if (targetTranslator != null) {
            this.targetTranslator = targetTranslator;
            this.charTranslator = null;
            this.htmlElementTranslator = null;
        }
        return this;
    }

    @Override
    public AsciiListContext setTextLeftChar(Character c) {
        if (c != null) {
            this.textLeftChar = c;
        }
        return this;
    }

    @Override
    public AsciiListContext setTextLeftMargin(int margin) {
        if (margin > -1) {
            this.textLeftMargin = margin;
        }
        return this;
    }

    @Override
    public AsciiListContext setTextRightChar(Character c) {
        if (c != null) {
            this.textRightChar = c;
        }
        return this;
    }

    @Override
    public AsciiListContext setTextRightMargin(int margin) {
        if (margin > -1) {
            this.textRightMargin = margin;
        }
        return this;
    }

    @Override
    public AsciiListContext setWidth(int width) {
        this.width = width;
        return this;
    }

    @Override
    public AsciiListContext setLineSeparator(String separator) {
        if (!StringUtils.isBlank((CharSequence)separator)) {
            this.lineSeparator = separator;
        }
        return this;
    }

    @Override
    public String getLineSeparator() {
        return this.lineSeparator;
    }
}

