/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.skb.interfaces.document.IsDocumentElement;
import de.vandermeer.skb.interfaces.transformers.Object_To_StrBuilder;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class AbstractAsciiListItem
implements AsciiListItem {
    protected StrBuilder text;
    protected AsciiList<?, ?, ?> list;

    public AbstractAsciiListItem(Object text) {
        Validate.notNull((Object)text);
        this.text = new StrBuilder();
        this.setText(text);
        this.list = null;
    }

    public AbstractAsciiListItem(Object text, AsciiList<?, ?, ?> list) {
        this(text);
        Validate.notNull(list);
        this.list = list;
    }

    @Override
    public AsciiList<?, ?, ?> getList() {
        return this.list;
    }

    @Override
    public String getRawText() {
        return this.text.toString().replaceAll("\\s+", " ");
    }

    @Override
    public StrBuilder getText() {
        return this.text;
    }

    @Override
    public boolean hasList() {
        return this.list != null;
    }

    protected void setText(Object obj) {
        Validate.notNull((Object)obj);
        if (obj instanceof IsDocumentElement) {
            throw new IllegalArgumentException("cannot add " + obj.getClass().getSimpleName() + " as text to a list");
        }
        this.text.appendSeparator(' ').append(Object_To_StrBuilder.convert((Object)obj));
    }

    public StrBuilder toLog() {
        StrBuilder ret = new StrBuilder();
        if (this.hasList()) {
            ret.append("List item: [").append(this.list.getClass().getSimpleName()).append('/').append(this.list.getContext().getLevel()).append("] - text == ").append(this.getRawText());
            for (AsciiListItem i : this.list.getItems()) {
                ret.appendNewLine().appendPadding(this.list.getContext().getLevel() * 2, ' ').append("- ").append(i.toLog());
            }
        } else {
            ret.append("Text item: ").append(this.getRawText());
        }
        return ret;
    }
}

