/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListContext;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.AsciiListRenderer;
import de.vandermeer.skb.interfaces.transformers.textformat.Text_To_FormattedText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public class AbstractAsciiListRenderer<I extends AsciiListItem, C extends AsciiListContext>
implements AsciiListRenderer<I, C> {
    String lineSeparator = null;

    @Override
    public Collection<StrBuilder> renderAsCollection(Set<I> items, C ctx, int width) {
        Validate.notNull(items);
        Validate.notNull(ctx);
        ArrayList<StrBuilder> ret = new ArrayList<StrBuilder>();
        if (ctx.getListStart() != null) {
            Validate.validState((ctx.getListStart().length() <= width ? 1 : 0) != 0, (String)"list start string longer than list width", (Object[])new Object[0]);
            ret.add(new StrBuilder().append(ctx.getListStart()).appendPadding(width - ctx.getListStart().length(), ctx.getTextRightChar().charValue()));
        }
        int index = 1;
        for (AsciiListItem item : items) {
            String text = item.getText().toString().replaceAll("\\s+", " ");
            if (ctx.getTargetTranslator() != null) {
                if (ctx.getTargetTranslator().getCombinedTranslator() != null) {
                    text = ctx.getTargetTranslator().getCombinedTranslator().translate(text);
                }
            } else if (ctx.getHtmlElementTranslator() != null) {
                text = ctx.getHtmlElementTranslator().translateHtmlElements(text);
            } else if (ctx.getCharTranslator() != null) {
                text = ctx.getCharTranslator().translateCharacters(text);
            }
            StrBuilder itemString = ctx.getItemString((AsciiListItem)item, index);
            Collection itList = Text_To_FormattedText.create((int)width, (int)ctx.getAlignment().getMapping(), (int)100, null, null, null, (int)0, (int)0, null, (int)0, (int)0, null).transform(text);
            int count = 0;
            for (StrBuilder sb : itList) {
                if (count == 0) {
                    sb.insert(0, (Object)itemString);
                } else if (count > 0) {
                    sb.insert(0, (Object)new StrBuilder().appendPadding(itemString.toString().length(), ' '));
                }
                sb.appendPadding(ctx.getTextRightMargin(), ctx.getTextRightChar().charValue());
                ret.add(sb);
                ++count;
            }
            if (item.hasList()) {
                if (item.getList() instanceof AsciiList) {
                    AsciiList al = (AsciiList)item.getList();
                    for (StrBuilder sb : al.renderAsChild((AsciiListContext)ctx, itemString.toString().length(), index)) {
                        ret.add(sb);
                    }
                } else {
                    throw new NotImplementedException("can only render classic AsciiLists");
                }
            }
            ++index;
        }
        if (ctx.getListEnd() != null) {
            Validate.validState((ctx.getListEnd().length() <= width ? 1 : 0) != 0, (String)"list end string longer than list width", (Object[])new Object[0]);
            ret.add(new StrBuilder().append(ctx.getListEnd()).appendPadding(width - ctx.getListEnd().length(), ctx.getTextRightChar().charValue()));
        }
        return ret;
    }

    @Override
    public void setLineSeparator(String separator) {
        if (!StringUtils.isBlank((CharSequence)separator)) {
            this.lineSeparator = separator;
        }
    }

    @Override
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public String render(Set<I> items, C ctx, int width) {
        Collection<StrBuilder> coll = this.renderAsCollection(items, ctx, width);
        String fileSeparator = this.getLineSeparator();
        if (fileSeparator == null) {
            fileSeparator = ctx.getLineSeparator();
        }
        if (fileSeparator == null) {
            fileSeparator = System.lineSeparator();
        }
        return new StrBuilder().appendWithSeparators(coll, fileSeparator).build();
    }
}

