/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.checklist;

import de.vandermeer.asciilist.AbstractAsciiListContext;
import de.vandermeer.asciilist.AsciiListContext;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.checklist.ChecklistItem;
import de.vandermeer.asciithemes.TA_Checklist;
import de.vandermeer.asciithemes.a7.A7_Checklists;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public class ChecklistContext
extends AbstractAsciiListContext {
    protected TA_Checklist style;
    protected boolean inheritStyle;

    public ChecklistContext() {
        this.init();
    }

    @Override
    public ChecklistContext copySettings(AsciiListContext ctx) {
        super.copySettings(ctx);
        if (ctx instanceof ChecklistContext) {
            this.style = ((ChecklistContext)ctx).style;
            this.inheritStyle = ((ChecklistContext)ctx).inheritStyle;
        }
        return this;
    }

    @Override
    public <LI extends AsciiListItem> StrBuilder getItemString(LI item, int index) {
        StrBuilder ret = new StrBuilder(20);
        ret.appendPadding(this.getItemMargin(), this.getItemChar().charValue()).append(this.getLeftLabelString()).appendPadding(this.getLabelLeftMargin(), this.getLabelLeftChar().charValue());
        if (item instanceof ChecklistItem) {
            ret.append(this.getStyle().getLabel(this.getLevel(), ((ChecklistItem)item).isChecked()));
        } else {
            ret.append(this.getStyle().getLabel(this.getLevel(), false));
        }
        ret.appendPadding(this.getLabelRightMargin(), this.getLabelRightChar().charValue()).append(this.getRightLabelString()).appendPadding(this.getTextLeftMargin(), this.getTextLeftChar().charValue());
        return ret;
    }

    public TA_Checklist getStyle() {
        return this.style;
    }

    @Override
    public ChecklistContext inheritSettings(AsciiListContext ctx) {
        if (ctx instanceof ChecklistContext && this.inheritStyle) {
            this.style = ((ChecklistContext)ctx).style;
        }
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.style = A7_Checklists.sbrX();
        this.inheritStyle = true;
    }

    public ChecklistContext setInheritStyle(boolean flag) {
        this.inheritStyle = flag;
        return this;
    }

    public ChecklistContext setStyle(TA_Checklist style) {
        Validate.notNull((Object)style);
        this.style = style;
        return this;
    }
}

