/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.descriptionlist;

import de.vandermeer.asciilist.AbstractAsciiListContext;
import de.vandermeer.asciilist.AsciiListContext;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.descriptionlist.DescriptionListItem;
import org.apache.commons.lang3.text.StrBuilder;

public class DescriptionListContext
extends AbstractAsciiListContext {
    protected int descriptionIndent;
    protected boolean useSameLine;

    public DescriptionListContext() {
        this.init();
    }

    @Override
    public DescriptionListContext copySettings(AsciiListContext ctx) {
        super.copySettings(ctx);
        if (ctx instanceof DescriptionListContext) {
            this.useSameLine = ((DescriptionListContext)ctx).useSameLine;
            this.descriptionIndent = ((DescriptionListContext)ctx).descriptionIndent;
        }
        return this;
    }

    @Override
    public StrBuilder getCalculatedItemString() {
        StrBuilder ret = new StrBuilder(20);
        ret.appendPadding(this.getDescriptionIndent(), this.getLabelLeftChar().charValue());
        return ret;
    }

    public int getDescriptionIndent() {
        return this.descriptionIndent;
    }

    @Override
    public <LI extends AsciiListItem> StrBuilder getItemString(LI item, int index) {
        StrBuilder ret = new StrBuilder(20);
        ret.appendPadding(this.getItemMargin(), this.getItemChar().charValue()).append(this.getLeftLabelString()).appendPadding(this.getLabelLeftMargin(), this.getLabelLeftChar().charValue());
        if (item instanceof DescriptionListItem) {
            ret.append(((DescriptionListItem)item).getKey());
        }
        ret.appendPadding(this.getLabelRightMargin(), this.getLabelRightChar().charValue()).append(this.getRightLabelString());
        if (item instanceof DescriptionListItem) {
            ret.appendPadding(this.getTextLeftMargin(), this.getTextLeftChar().charValue());
        }
        return ret;
    }

    public boolean getUseSameLine() {
        return this.useSameLine;
    }

    @Override
    public DescriptionListContext inheritSettings(AsciiListContext ctx) {
        if (ctx instanceof DescriptionListContext) {
            // empty if block
        }
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.useSameLine = false;
        this.descriptionIndent = 4;
    }

    public DescriptionListContext setDescriptionIndent(int descriptionIndent) {
        if (descriptionIndent > -1) {
            this.descriptionIndent = descriptionIndent;
        }
        return this;
    }

    public DescriptionListContext setUseSameLine(boolean useSameLine) {
        this.useSameLine = useSameLine;
        return this;
    }
}

