/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.descriptionlist;

import de.vandermeer.asciilist.AbstractAsciiListRenderer;
import de.vandermeer.asciilist.descriptionlist.DescriptionListContext;
import de.vandermeer.asciilist.descriptionlist.DescriptionListItem;
import de.vandermeer.skb.interfaces.transformers.textformat.Text_To_FormattedText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public class DescriptionListRenderer
extends AbstractAsciiListRenderer<DescriptionListItem, DescriptionListContext> {
    static DescriptionListRenderer create() {
        return new DescriptionListRenderer(){};
    }

    @Override
    public Collection<StrBuilder> renderAsCollection(Set<DescriptionListItem> items, DescriptionListContext ctx, int width) {
        Validate.notNull(items);
        Validate.notNull((Object)ctx);
        ArrayList<StrBuilder> ret = new ArrayList<StrBuilder>();
        if (ctx.getListStart() != null) {
            Validate.validState((ctx.getListStart().length() <= width ? 1 : 0) != 0, (String)"list start string longer than list width", (Object[])new Object[0]);
            ret.add(new StrBuilder().append(ctx.getListStart()).appendPadding(width - ctx.getListStart().length(), ctx.getTextRightChar().charValue()));
        }
        int index = 1;
        for (DescriptionListItem item : items) {
            String text = item.getText().toString().replaceAll("\\s+", " ");
            if (ctx.getTargetTranslator() != null) {
                if (ctx.getTargetTranslator().getCombinedTranslator() != null) {
                    text = ctx.getTargetTranslator().getCombinedTranslator().translate(text);
                }
            } else if (ctx.getHtmlElementTranslator() != null) {
                text = ctx.getHtmlElementTranslator().translateHtmlElements(text);
            } else if (ctx.getCharTranslator() != null) {
                text = ctx.getCharTranslator().translateCharacters(text);
            }
            StrBuilder itemString = ctx.getItemString(item, index);
            Collection itList = null;
            itList = ctx.getUseSameLine() ? Text_To_FormattedText.create((int)width, (int)ctx.getAlignment().getMapping(), (int)103, null, null, null, (int)0, (int)itemString.length(), null, (int)0, (int)0, null).transform(text) : Text_To_FormattedText.create((int)(width - ctx.getDescriptionIndent()), (int)ctx.getAlignment().getMapping(), (int)100, null, null, null, (int)0, (int)0, null, (int)0, (int)0, null).transform(text);
            if (!ctx.getUseSameLine()) {
                ret.add(new StrBuilder().append(itemString).appendPadding(width - itemString.size(), ctx.getTextRightChar().charValue()));
            }
            int count = 0;
            for (StrBuilder sb : itList) {
                if (count == 0 && ctx.getUseSameLine()) {
                    sb.replace(0, itemString.length(), itemString.toString());
                } else if (!ctx.getUseSameLine()) {
                    sb.insert(0, (Object)new StrBuilder().appendPadding(ctx.getDescriptionIndent(), ' '));
                }
                sb.appendPadding(ctx.getTextRightMargin(), ctx.getTextRightChar().charValue());
                ret.add(sb);
                ++count;
            }
            if (item.hasList()) {
                for (StrBuilder sb : item.getList().renderAsChild(ctx, itemString.toString().length(), index)) {
                    ret.add(sb);
                }
            }
            ++index;
        }
        if (ctx.getListEnd() != null) {
            Validate.validState((ctx.getListEnd().length() <= width ? 1 : 0) != 0, (String)"list end string longer than list width", (Object[])new Object[0]);
            ret.add(new StrBuilder().append(ctx.getListEnd()).appendPadding(width - ctx.getListEnd().length(), ctx.getTextRightChar().charValue()));
        }
        return ret;
    }
}

