/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.enumerate;

import de.vandermeer.asciilist.AbstractAsciiListContext;
import de.vandermeer.asciilist.AsciiListContext;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciithemes.TA_EnumerateList;
import de.vandermeer.asciithemes.a7.A7_EnumerateLists;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public class EnumerateListContext
extends AbstractAsciiListContext {
    protected String numberingSeparator = ".";
    protected TA_EnumerateList style = A7_EnumerateLists.number();
    protected boolean useSeparatorAfterLastNumber = true;
    protected boolean inheritStyle = true;

    public EnumerateListContext() {
        this.init();
    }

    @Override
    public EnumerateListContext copySettings(AsciiListContext ctx) {
        super.copySettings(ctx);
        if (ctx instanceof EnumerateListContext) {
            this.style = ((EnumerateListContext)ctx).style;
            this.inheritStyle = ((EnumerateListContext)ctx).inheritStyle;
            this.useSeparatorAfterLastNumber = ((EnumerateListContext)ctx).useSeparatorAfterLastNumber;
            this.numberingSeparator = ((EnumerateListContext)ctx).numberingSeparator;
        }
        return this;
    }

    @Override
    public <LI extends AsciiListItem> StrBuilder getItemString(LI item, int index) {
        StrBuilder ret = new StrBuilder(20);
        ret.appendPadding(this.getItemMargin(), this.getItemChar().charValue()).append(this.getLeftLabelString()).appendPadding(this.getLabelLeftMargin(), this.getLabelLeftChar().charValue());
        if (this.parentIndex != null && index > 0) {
            int[] levels = ArrayUtils.add((int[])this.parentIndex, (int)index);
            ret.append(this.getStyle().getLabel(levels, this.numberingSeparator, this.useSeparatorAfterLastNumber));
        } else if (index > 0) {
            ret.append(this.getStyle().getLabel(index));
            if (this.useSeparatorAfterLastNumber) {
                ret.append(this.numberingSeparator);
            }
        } else {
            ret.append(this.getStyle().getLabel(this.getLevel()));
        }
        ret.appendPadding(this.getLabelRightMargin(), this.getLabelRightChar().charValue()).append(this.getRightLabelString()).appendPadding(this.getTextLeftMargin(), this.getTextLeftChar().charValue());
        return ret;
    }

    public String getNumberingSeparator() {
        return this.numberingSeparator;
    }

    public boolean getSeparatorAfterLastNumber() {
        return this.useSeparatorAfterLastNumber;
    }

    public TA_EnumerateList getStyle() {
        return this.style;
    }

    @Override
    public EnumerateListContext inheritSettings(AsciiListContext ctx) {
        if (ctx instanceof EnumerateListContext && this.inheritStyle) {
            this.style = ((EnumerateListContext)ctx).style;
        }
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.numberingSeparator = ".";
    }

    public EnumerateListContext setInheritStyle(boolean flag) {
        this.inheritStyle = flag;
        return this;
    }

    public EnumerateListContext setNumberingSeparator(String numberingSeparator) {
        this.numberingSeparator = numberingSeparator;
        return this;
    }

    public EnumerateListContext setSeparatorAfterLastNumber(boolean flag) {
        this.useSeparatorAfterLastNumber = flag;
        return this;
    }

    public EnumerateListContext setStyle(TA_EnumerateList style) {
        Validate.notNull((Object)style);
        this.style = style;
        return this;
    }
}

