/* Copyright 2015 Sven van der Meer <vdmeer.sven@mykolab.com\>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.vandermeer.translation.characters;

import org.apache.commons.lang3.StringUtils;

import de.vandermeer.skb.interfaces.translators.CharacterTranslator;

/**
 * Translator for plain text characters to LaTeX.
 *
 * @author     Sven van der Meer &lt;vdmeer.sven@mykolab.com&gt; - auto-generated by SKB Datatool from SKB CharacterMap data
 * @version    v0.0.2 build 170404 (04-Apr-17) for Java 1.8
 * @since      v0.0.1
 */
public class Text2Latex implements CharacterTranslator {

	/** Array of source strings. */
	protected String[] sourceArray = new String[]{
		" ", "#", "$", "%", "&", "*", "<", ">", "?", "@", "[", "\"", "\\", "]", "^", "_", "{", "|", "}", "~", "¡", "¢", "£", "¤", "§", "¨", "©", "ª", "¬", "®", "¯", "°", "±", "²", "³", "µ", "¶", "·", "¹", "º", "¼", "½", "¾", "¿", "À", "Á", "Â", "Ã", "Ä", "Å", "Æ", "Ç", "È", "É", "Ê", "Ë", "Ì", "Í", "Î", "Ï", "Ð", "Ñ", "Ò", "Ó", "Ô", "Õ", "Ö", "×", "Ø", "Ù", "Ú", "Û", "Ü", "Ý", "Þ", "ß", "à", "á", "â", "ã", "ä", "å", "æ", "ç", "è", "é", "ê", "ë", "ì", "í", "î", "ï", "ð", "ñ", "ò", "ó", "ô", "õ", "ö", "÷", "ø", "ù", "ú", "û", "ü", "ý", "þ", "ÿ", "Š", "š", "Ÿ", "ˆ", "˜", "Α", "Β", "Γ", "Δ", "Ε", "Ζ", "Η", "Θ", "Ι", "Κ", "Λ", "Μ", "Ν", "Ξ", "Ο", "Π", "Ρ", "Σ", "Τ", "Υ", "Φ", "Χ", "Ψ", "Ω", "α", "β", "γ", "δ", "ε", "ζ", "η", "θ", "ι", "κ", "λ", "μ", "ν", "ξ", "ο", "π", "ρ", "ς", "σ", "τ", "υ", "φ", "χ", "ψ", "ω", "ϑ", "ϖ", "–", "—", "‘", "’", "‚", "“", "”", "†", "‡", "…", "€", "™", "←", "↑", "→", "↓", "↔", "⇐", "⇑", "⇒", "⇓", "⇔", "∀", "∃", "∈", "∉", "∏", "∑", "∞", "∧", "∨", "∩", "∪", "≈", "≠", "≤", "≥"
	};

	/** Array of target strings. */
	protected String[] targetArray = new String[]{
		" ", "\\#", "\\$", "\\%", "\\&", "\\textasteriskcentered", "\\textless", "\\textgreater", "\\?", "\\@", "\\[", "\"", "\\textbackslash", "\\]", "\\textasciicircum", "\\_", "\\{", "\\textbar", "\\}", "\\textasciitilde", "\\textexclamdown", "\\cent", "\\pounds", "\\currency", "{\\S}", "\\textasciidieresis", "{\\copyright}", "\\textordfeminine", "\\textlnot", "{\\textregistered}", "\\textasciimacron", "\\textdegree", "\\textpm", "\\texttwosuperior", "\\textthreesuperior", "\\textmu", "\\P", "\\textperiodcentered", "\\textonesuperior", "\\textordmasculine", "\\textonequarter", "\\textonehalf", "\\textthreequarters", "\\textquestiondown", "\\`{A}", "\\'{A}", "\\^{A}", "\\~{A}", "\\\"{A}", "\\AA", "\\AE", "\\c{C}", "\\`{E}", "\\'{E}", "\\^{E}", "\\\"{E}", "\\`{I}", "\\'{I}", "\\^{I}", "\\\"{I}", "\\DH", "\\~{N}", "\\`{O}", "\\'{O}", "\\^{O}", "\\~{O}", "\\\"{O}", "\\texttimes", "\\O", "\\`{U}", "\\'{U}", "\\^{U}", "\\\"{U}", "\\'{Y}", "\\TH", "{\\ss}", "\\'{a}", "\\^{a}", "\\`{a}", "\\~{a}", "\\\"{a}", "\\aa", "\\ae", "\\c{c}", "\\`{e}", "\\'{e}", "\\^{e}", "\\\"{e}", "\\`{i}", "\\'{i}", "\\^{i}", "\\\"{i}", "\\dh", "\\~{n}", "\\`{o}", "\\'{o}", "\\^{o}", "\\~{o}", "\\\"{o}", "\\textdiv", "\\o", "\\`{u}", "\\'{u}", "\\^{u}", "\\\"{u}", "\\'{y}", "\\th", "\\\"{u}", "\\v{S}", "\\v{s}", "\\\"{Y}", "\\texcuub", "	extasciitilde", "A", "B", "\\Gamma", "\\Delta", "E", "Z", "H", "\\Theta", "I", "K", "\\Lambda", "M", "N", "\\Xi", "O", "\\Pi", "P", "\\Sigma", "T", "\\Upsilon", "\\Phi", "X", "\\Psi", "\\Omega", "\\alpha", "\\beta", "\\gamma", "\\delta", "\\epsilon", "\\zeta", "\\eta", "\\theta", "\\iota", "\\kappa", "\\lambda", "\\mu", "\\nu", "\\xi", "o", "\\pi", "\\rho", "\\varsigma", "\\sigma", "\\tau", "\\upsilon", "\\phi", "\\chi", "\\psi", "\\omega", "\\vartheta", "\\varpi", "--", "---", "`", "'", ",", "``", "''", "\\dag", "\\ddag", "{\\dots}", "{\\euro}", "{\\texttrademark}", "\\(\\leftarrow{}\\)", "\\(\\uparrow\\)", "\\(\\rightarrow{}\\)", "\\(\\downarrow{}\\)", "\\(\\leftrightarrow{}\\)", "\\(\\Leftarrow{}\\)", "\\(\\Uparrow\\)", "\\(\\Rightarrow{}\\)", "\\(\\Downarrow{}\\)", "\\(\\Leftrightarrow{}\\)", "$\\forall$", "$\\exists$", "$\\in$", "$\\notin$", "$\\prod$", "$\\sum$", "$infty$", "$\\wedge$", "$\\vee$", "$\\cap$", "$\\cup$", "$\\approx{}$", "$\\neq$", "$\\leq$", "$\\geq$"
	};

	@Override
	public String translateCharacters(String input){
		return StringUtils.replaceEach(input, this.sourceArray, this.targetArray);
	}
}
