/* Copyright 2014 Sven van der Meer <vdmeer.sven@mykolab.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.vandermeer.skb.base.shell;

import de.vandermeer.skb.interfaces.categories.has.HasDescription;

/**
 * An argument type for the {@link SkbShell}.
 *
 * @author     Sven van der Meer &lt;vdmeer.sven@mykolab.com&gt;
 * @version    v0.2.0 build 170404 (04-Apr-17) for Java 1.8
 * @since      v0.0.8
 */
public enum SkbShellArgumentType implements HasDescription {

	/** A Boolean type. */
	Boolean ("a java.lang.Boolean"),

	/** A Char type. */
	Char ("a java.lang.Char"),

	/** A Double type. */
	Double ("a java.lang.Double"),

	/** An Integer type. */
	Integer ("a java.lang.Integer"),

	/** A String type. */
	String ("a java.lang.String"),

	/** A list of strings. */
	ListString ("A list of strings"),

	/** A list of integers. */
	ListInteger ("A list of integers"),

	;

	/** A description. */
	String description;

	/**
	 * Creates a new shell argument type.
	 * @param description type description
	 */
	SkbShellArgumentType(String description){
		this.description = description;
	}

	@Override
	public String getDescription(){
		return this.description;
	}

}
