/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.console;

import de.vandermeer.skb.interfaces.MessageConsole;
import de.vandermeer.skb.interfaces.categories.has.HasPrompt;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class NonBlockingReader {
    public static Callable<String> getCallWTimeout(BufferedReader reader, HasPrompt emptyPrint) {
        return NonBlockingReader.getCallWTimeout(reader, 200, emptyPrint);
    }

    public static Callable<String> getCallWTimeout(final BufferedReader reader, final int timeout, final HasPrompt emptyPrint) {
        return new Callable<String>(){

            @Override
            public String call() throws IOException {
                String ret = "";
                while ("".equals(ret)) {
                    try {
                        while (!reader.ready()) {
                            Thread.sleep(timeout);
                        }
                        ret = reader.readLine();
                        if (!"".equals(ret) || emptyPrint == null) continue;
                        System.out.print(emptyPrint.prompt());
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
                return ret;
            }
        };
    }

    public static BufferedReader getNbReader(String logID, int tries, int timeout, HasPrompt emptyPrint) {
        return NonBlockingReader.getNbReader(MessageConsole.getStdIn((String)logID), tries, timeout, emptyPrint);
    }

    public static BufferedReader getNbReader(final BufferedReader reader, final int tries, final int timeout, final HasPrompt emptyPrint) {
        if (reader == null) {
            return null;
        }
        return new BufferedReader(reader){
            ExecutorService ex;
            {
                super(x0);
                this.ex = Executors.newSingleThreadExecutor();
            }

            @Override
            public String readLine() {
                String input = null;
                for (int i = 0; i < tries; ++i) {
                    Future<String> result = this.ex.submit(NonBlockingReader.getCallWTimeout(reader, emptyPrint));
                    try {
                        input = result.get(timeout, TimeUnit.MILLISECONDS);
                        break;
                    }
                    catch (ExecutionException executionException) {
                        continue;
                    }
                    catch (TimeoutException e) {
                        result.cancel(true);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        this.ex.shutdownNow();
                    }
                }
                return input;
            }
        };
    }
}

