/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.DirectoryValidator;
import de.vandermeer.skb.base.info.InfoLocationOptions;
import de.vandermeer.skb.base.info.ValidationOptions;
import de.vandermeer.skb.interfaces.messagesets.IsErrorSetFT;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDirectoryInfo {
    protected File file;
    protected URL url;
    private String fullDirectoryName;
    private String setRootPath;
    protected final IsErrorSetFT errors = IsErrorSetFT.create();
    protected Options asStringOpt = Options.AS_STRING_SET_ROOT_PATH;

    public AbstractDirectoryInfo(String directory) {
        this(directory, InfoLocationOptions.TRY_CLASSPATH_THEN_FS);
    }

    public AbstractDirectoryInfo(String directory, InfoLocationOptions option) {
        if (directory == null) {
            this.errors.addError("constructor(directory) - directory cannot be null");
        } else if (StringUtils.isBlank((CharSequence)directory)) {
            this.errors.addError("constructor(directory) - directory cannot be blank");
        } else if (option == null) {
            this.errors.addError("constructor(directory) - option cannot be blank");
        } else {
            this.init(directory, option);
        }
    }

    protected void reset() {
        this.url = null;
        this.file = null;
        this.fullDirectoryName = null;
        this.setRootPath = null;
    }

    protected void init(String directory, InfoLocationOptions option) {
        block15: {
            if (this.valOption() == null) {
                this.errors.addError("constructor(init) - no validation option set");
                return;
            }
            try {
                if (directory == null) break block15;
                switch (option) {
                    case FILESYSTEM_ONLY: {
                        if (!this.tryFS(directory) && !this.tryCP(directory)) {
                            this.errors.addError("constructor(init) - could not find directory <" + directory + ">, tried file system");
                        }
                        break;
                    }
                    case CLASSPATH_ONLY: {
                        if (!this.tryCP(directory) && !this.tryCP(directory)) {
                            this.errors.addError("constructor(init) - could not find directory <" + directory + ">>, tried using class path");
                        }
                        break;
                    }
                    case TRY_FS_THEN_CLASSPATH: {
                        if (!this.tryFS(directory)) {
                            this.errors.clearErrorMessages();
                            if (!this.tryCP(directory)) {
                                this.errors.addError("constructor(init) - could not find directory <" + directory + ">, tried file system then using class path");
                            }
                        }
                        break;
                    }
                    case TRY_CLASSPATH_THEN_FS: {
                        if (!this.tryCP(directory)) {
                            this.errors.clearErrorMessages();
                            if (!this.tryFS(directory)) {
                                this.errors.addError("constructor(init) - could not find directory <" + directory + ">, tried using class path then file system");
                            }
                        }
                        break;
                    }
                    default: {
                        this.errors.addError("constructor(init) - unknown location option <" + (Object)((Object)option) + "> for directories");
                    }
                }
            }
            catch (Exception ex) {
                this.errors.addError("init() - catched unpredicted exception: " + ex.getMessage());
            }
        }
    }

    protected final boolean tryFS(String directory) {
        String path = directory;
        File file = new File(path);
        if (this.testDirectory(file)) {
            try {
                this.url = file.toURI().toURL();
                this.file = file;
                this.fullDirectoryName = FilenameUtils.getPath((String)file.getAbsolutePath());
                this.setRootPath = directory;
                return true;
            }
            catch (MalformedURLException e) {
                this.errors.addError("init() - malformed URL for file with name " + this.file.getAbsolutePath() + " and message: " + e.getMessage());
            }
        }
        return false;
    }

    protected final boolean tryCP(String directory) {
        String[] cp;
        for (String s : cp = StringUtils.split((String)System.getProperty("java.class.path"), (char)File.pathSeparatorChar)) {
            String path;
            File file;
            if (StringUtils.endsWith((CharSequence)s, (CharSequence)".jar") || StringUtils.startsWith((CharSequence)s, (CharSequence)"/") || !this.testDirectory(file = new File(path = s + File.separator + directory))) continue;
            try {
                this.url = file.toURI().toURL();
                this.file = file;
                this.fullDirectoryName = FilenameUtils.getPath((String)file.getAbsolutePath());
                this.setRootPath = directory;
                return true;
            }
            catch (MalformedURLException e) {
                this.errors.addError("init() - malformed URL for file with name " + this.file.getAbsolutePath() + " and message: " + e.getMessage());
            }
        }
        return false;
    }

    protected final boolean testDirectory(File directory) {
        DirectoryValidator dv = new DirectoryValidator(directory, this.valOption());
        this.errors.addAllErrors(dv.getValidationErrors());
        return !dv.getValidationErrors().hasErrors();
    }

    public File asFile() {
        return this.file;
    }

    public URL asURL() {
        return this.url;
    }

    public String getFullDirecoryName() {
        return this.fullDirectoryName;
    }

    public String getSetRootPath() {
        if (this.isValid()) {
            return this.setRootPath;
        }
        return null;
    }

    public boolean isValid() {
        return !this.errors.hasErrors();
    }

    protected abstract ValidationOptions valOption();

    public void setAsStringOption(Options option) {
        if (option != null) {
            this.asStringOpt = option;
        }
    }

    public static enum Options {
        AS_STRING_FULL_DIRECTORY_NAME,
        AS_STRING_SET_ROOT_PATH;

    }
}

