/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.base.info;

import de.vandermeer.skb.base.info.FileValidator;
import de.vandermeer.skb.base.info.InfoLocationOptions;
import de.vandermeer.skb.base.info.ValidationOptions;
import de.vandermeer.skb.interfaces.messagesets.IsErrorSetFT;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractFileInfo {
    protected File file;
    protected URL url;
    private String fullFileName;
    private String setRootPath;
    protected final IsErrorSetFT errors = IsErrorSetFT.create();
    protected Options asStringOpt = Options.AS_STRING_SET_ROOT_NAME;

    public AbstractFileInfo(File file, boolean doValidate) {
        if (doValidate) {
            this.init(file, null, null, null);
        } else if (file != null) {
            try {
                this.url = file.toURI().toURL();
                this.file = file;
                this.fullFileName = FilenameUtils.getName((String)file.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                this.errors.addError("constructor(file, boolean) - malformed URL for file with name " + this.file.getAbsolutePath() + " and message: " + e.getMessage());
            }
        } else {
            this.errors.addError("constructor(file, boolean) - file cannot be null");
        }
    }

    public AbstractFileInfo(File file, String setRoot) {
        if (file == null) {
            this.errors.addError("constructor(file, setRoot) - file cannot be null");
        } else if (setRoot == null) {
            this.errors.addError("constructor(file, setRoot) - setRoot cannot be null");
        } else {
            try {
                this.url = file.toURI().toURL();
                this.file = file;
                this.fullFileName = FilenameUtils.getName((String)file.getAbsolutePath());
                this.setRootPath = setRoot;
            }
            catch (MalformedURLException e) {
                this.errors.addError("constructor(file, boolean) - malformed URL for file with name " + this.file.getAbsolutePath() + " and message: " + e.getMessage());
            }
        }
    }

    public AbstractFileInfo(File file) {
        if (file == null) {
            this.errors.addError("constructor(file) - file cannot be null");
        } else {
            this.init(file, null, null, null);
        }
    }

    public AbstractFileInfo(String fileName) {
        this(fileName, InfoLocationOptions.TRY_RESOURCE_THEN_FS);
    }

    public AbstractFileInfo(String fileName, InfoLocationOptions option) {
        if (fileName == null) {
            this.errors.addError("constructor(fileName) - fileName cannot be null");
        } else if (StringUtils.isBlank((CharSequence)fileName)) {
            this.errors.addError("constructor(fileName) - fileName cannot be blank");
        } else if (option == null) {
            this.errors.addError("constructor(fileName) - option cannot be blank");
        } else {
            this.init(null, null, fileName, option);
        }
    }

    public AbstractFileInfo(String directory, String fileName) {
        this(directory, fileName, InfoLocationOptions.TRY_RESOURCE_THEN_FS);
    }

    public AbstractFileInfo(String directory, String fileName, InfoLocationOptions option) {
        if (directory == null) {
            this.errors.addError("constructor(directory, fileName) - directory cannot be null");
        } else if (StringUtils.isBlank((CharSequence)directory)) {
            this.errors.addError("constructor(directory, fileName) - directory cannot be blank");
        } else if (fileName == null) {
            this.errors.addError("constructor(directory, fileName) - fileName cannot be null");
        } else if (StringUtils.isBlank((CharSequence)fileName)) {
            this.errors.addError("constructor(directory, fileName) - fileName cannot be blank");
        } else if (option == null) {
            this.errors.addError("constructor(directory, fileName) - option cannot be blank");
        } else {
            this.init(null, directory, fileName, option);
        }
    }

    protected void reset() {
        this.url = null;
        this.file = null;
        this.fullFileName = null;
    }

    protected void init(File file, String directory, String fileName, InfoLocationOptions option) {
        block22: {
            if (this.valOption() == null) {
                this.errors.addError("constructor(init) - no validation option set");
                return;
            }
            try {
                if (file != null) {
                    if (this.testFile(file)) {
                        this.url = file.toURI().toURL();
                        this.file = file;
                        this.fullFileName = FilenameUtils.getName((String)file.getAbsolutePath());
                    }
                    break block22;
                }
                if (directory != null && fileName != null || fileName != null) {
                    switch (option) {
                        case FILESYSTEM_ONLY: {
                            if (!this.tryFS(directory, fileName) && !this.tryResource(directory, fileName)) {
                                if (directory != null) {
                                    this.errors.addError("constructor(init) - could not find anything for directory <" + directory + "> and fileName <" + fileName + ">, tried file system");
                                    break;
                                }
                                this.errors.addError("constructor(init) - could not find anything for fileName <" + fileName + ">, tried file system");
                                break;
                            }
                            break block22;
                        }
                        case RESOURCE_ONLY: {
                            if (!this.tryResource(directory, fileName) && !this.tryResource(directory, fileName)) {
                                if (directory != null) {
                                    this.errors.addError("constructor(init) - could not find anything for directory <" + directory + "> and fileName <" + fileName + ">, tried as resource");
                                    break;
                                }
                                this.errors.addError("constructor(init) - could not find anything for fileName <" + fileName + ">, tried as resource");
                                break;
                            }
                            break block22;
                        }
                        case TRY_FS_THEN_RESOURCE: {
                            if (!this.tryFS(directory, fileName)) {
                                this.errors.clearErrorMessages();
                                if (!this.tryResource(directory, fileName)) {
                                    if (directory != null) {
                                        this.errors.addError("constructor(init) - could not find anything for directory <" + directory + "> and fileName <" + fileName + ">, tried file system then as resource");
                                        break;
                                    }
                                    this.errors.addError("constructor(init) - could not find anything for fileName <" + fileName + ">, tried file system then as resource");
                                    break;
                                }
                            }
                            break block22;
                        }
                        case TRY_RESOURCE_THEN_FS: {
                            if (!this.tryResource(directory, fileName)) {
                                this.errors.clearErrorMessages();
                                if (!this.tryFS(directory, fileName)) {
                                    if (directory != null) {
                                        this.errors.addError("constructor(init) - could not find anything for directory <" + directory + "> and fileName <" + fileName + ">, tried as resource then file system");
                                        break;
                                    }
                                    this.errors.addError("constructor(init) - could not find anything for fileName <" + fileName + ">, tried as resource then file system");
                                    break;
                                }
                            }
                            break block22;
                        }
                        default: {
                            this.errors.addError("constructor(init) - unknown location option <" + (Object)((Object)option) + "> for files");
                            break;
                        }
                    }
                    break block22;
                }
                this.errors.addError("init() - unresolvable problems with input paramters, implementation problem(!)");
            }
            catch (Exception ex) {
                this.errors.addError("init() - catched unpredicted exception: " + ex.getMessage());
            }
        }
    }

    protected final boolean tryFS(String directory, String fileName) {
        File file;
        String path = directory + "/" + fileName;
        if (directory == null) {
            path = fileName;
        }
        if (this.testFile(file = new File(path))) {
            try {
                this.url = file.toURI().toURL();
                this.file = file;
                this.fullFileName = FilenameUtils.getName((String)file.getAbsolutePath());
                if (directory != null) {
                    this.setRootPath = directory;
                }
                return true;
            }
            catch (MalformedURLException e) {
                this.errors.addError("init() - malformed URL for file with name " + this.file.getAbsolutePath() + " and message: " + e.getMessage());
            }
        }
        return false;
    }

    protected final boolean tryResource(String directory, String fileName) {
        ClassLoader loader;
        URL url;
        String path = directory + "/" + fileName;
        if (directory == null) {
            path = fileName;
        }
        if ((url = (loader = Thread.currentThread().getContextClassLoader()).getResource(path)) == null) {
            loader = AbstractFileInfo.class.getClassLoader();
            url = loader.getResource(path);
        }
        if (url == null) {
            this.errors.addError("could not get Resource URL");
            return false;
        }
        this.url = url;
        this.fullFileName = FilenameUtils.getName((String)fileName);
        if (directory != null) {
            this.setRootPath = directory;
        }
        return true;
    }

    protected final boolean testFile(File file) {
        FileValidator fv = new FileValidator(file, this.valOption());
        this.errors.addAllErrors(fv.getValidationErrors());
        return !fv.getValidationErrors().hasErrors();
    }

    public File asFile() {
        return this.file;
    }

    public URL asURL() {
        return this.url;
    }

    public String getFileExtension() {
        if (this.isValid()) {
            return FilenameUtils.getExtension((String)this.fullFileName);
        }
        return null;
    }

    public String getBaseFileName() {
        if (this.isValid()) {
            return FilenameUtils.getBaseName((String)this.fullFileName);
        }
        return null;
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public String getAbsolutePath() {
        if (this.isValid()) {
            if (this.asFile() != null) {
                return FilenameUtils.getFullPathNoEndSeparator((String)this.file.getAbsolutePath());
            }
            return FilenameUtils.getFullPathNoEndSeparator((String)this.url.getPath());
        }
        return null;
    }

    public String getAbsoluteName() {
        if (this.isValid()) {
            if (this.asFile() != null) {
                return this.file.getAbsolutePath();
            }
            return this.url.getPath();
        }
        return null;
    }

    public String getSetRootPath() {
        if (this.isValid()) {
            return this.setRootPath;
        }
        return null;
    }

    public String getSetRootName() {
        if (this.isValid() && this.setRootPath != null) {
            return this.setRootPath + "/" + this.fullFileName;
        }
        return null;
    }

    public String getRootPath() {
        if (this.isValid() && this.setRootPath != null) {
            return StringUtils.substringBefore((String)this.getAbsolutePath(), (String)this.setRootPath);
        }
        return null;
    }

    public String toString() {
        if (this.isValid()) {
            FormattingTuple ret = MessageFormatter.arrayFormat((String)"file[{}]\nurl [{}]\nfull / base / extension [{}, {}, {}]\nabsPath[{}]\nabsName[{}]\nsetRootPath[{}]\nsetRootName[{}]\nrootPath[{}]", (Object[])new Object[]{this.asFile(), this.asURL(), this.getFullFileName(), this.getBaseFileName(), this.getFileExtension(), this.getAbsolutePath(), this.getAbsoluteName(), this.getSetRootPath(), this.getSetRootName(), this.getRootPath()});
            return ret.getMessage();
        }
        return "not valid";
    }

    public boolean isValid() {
        return !this.errors.hasErrors();
    }

    protected abstract ValidationOptions valOption();

    public void setAsStringOption(Options option) {
        if (option != null) {
            this.asStringOpt = option;
        }
    }

    public static enum Options {
        AS_STRING_ABSOLUTE_PATH,
        AS_STRING_ABSOLUTE_NAME,
        AS_STRING_FULL_FILE_NAME,
        AS_STRING_BASE_FILE_NAME,
        AS_STRING__FILE_EXTENSION,
        AS_STRING_ROOT_PATH,
        AS_STRING_SET_ROOT_PATH,
        AS_STRING_SET_ROOT_NAME;

    }
}

